/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import globals.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.metal.MetalIconFactory;

public class LibraryPanel
extends JPanel
implements PropertyChangeListener {
    private static final int PREFERRED_PANEL_WIDTH = 250;
    private final JFileChooser fc;
    private final LibraryListModel listModel;

    public LibraryPanel(JFileChooser fc) {
        this.fc = fc;
        fc.addPropertyChangeListener(this);
        fc.setAccessory(this);
        this.listModel = new LibraryListModel();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LibraryPanel.this.initGUI();
            }
        });
        this.listModel.setDirectory(fc.getCurrentDirectory());
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(250, 1));
        if (Globals.messages == null) {
            this.add("North", new JLabel("Libraries in directory:"));
        } else {
            this.add("North", new JLabel(Globals.messages.getString("lib_in_dir")));
        }
        JList<LibraryDesc> fileList = new JList<LibraryDesc>(this.listModel);
        fileList.setCellRenderer(new ListCellRenderer<LibraryDesc>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends LibraryDesc> list, LibraryDesc value, int index, boolean isSelected, boolean cellHasFocus) {
                LibraryDesc desc = value;
                Icon icon = MetalIconFactory.getTreeFloppyDriveIcon();
                SpaceIcon spaceIcon = new SpaceIcon(icon.getIconWidth(), icon.getIconHeight());
                String libraryName = desc.libraryName == null ? "---" : "(" + desc.libraryName + ")";
                JPanel p = new JPanel();
                p.setBorder(new EmptyBorder(2, 0, 3, 0));
                p.setOpaque(false);
                p.setLayout(new BorderLayout());
                p.add("North", new JLabel(desc.filename, icon, 2));
                p.add("South", new JLabel(libraryName, spaceIcon, 2));
                return p;
            }
        });
        JScrollPane sp = new JScrollPane(fileList);
        sp.setVerticalScrollBarPolicy(22);
        this.add("Center", sp);
        fileList.setFocusable(false);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
            this.listModel.setDirectory(this.fc.getSelectedFile());
        }
        if (evt.getPropertyName().equals("directoryChanged")) {
            this.listModel.setDirectory(this.fc.getCurrentDirectory());
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setPreferredSize(new Dimension(800, 400));
                new LibraryPanel(fc);
                fc.showOpenDialog(null);
            }
        });
    }

    private class SpaceIcon
    implements Icon {
        private final int width;
        private final int height;

        SpaceIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    private class LibraryDesc {
        public String filename;
        public String libraryName;

        private LibraryDesc() {
        }

        public String toString() {
            return String.format("%s (%s)", this.filename, this.libraryName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LibraryListModel
    implements ListModel<LibraryDesc> {
        private final ArrayList<ListDataListener> listeners = new ArrayList();
        private final ArrayList<LibraryDesc> libraryList = new ArrayList();
        private File currentDir;

        LibraryListModel() {
        }

        public void setDirectory(File dir) {
            this.currentDir = dir;
            this.clearList();
            if (this.currentDir != null && this.currentDir.canRead() && this.currentDir.isDirectory()) {
                this.refreshList();
            }
            this.fireChanged();
        }

        private void refreshList() {
            File[] files;
            for (File f : files = this.currentDir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isFile() && f.getName().toLowerCase().matches("^.*\\.fcl$");
                }
            })) {
                LibraryDesc desc = new LibraryDesc();
                desc.filename = f.getName();
                desc.libraryName = this.getLibraryName(f);
                this.libraryList.add(desc);
            }
            Collections.sort(this.libraryList, new Comparator<LibraryDesc>(){

                @Override
                public int compare(LibraryDesc ld1, LibraryDesc ld2) {
                    return ld1.filename.compareTo(ld2.filename);
                }

                @Override
                public boolean equals(Object obj) {
                    return this == obj;
                }
            });
        }

        private void clearList() {
            this.libraryList.clear();
        }

        private void fireChanged() {
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(new ListDataEvent(this, 0, 0, 0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getLibraryName(File f) {
            int maxReadline = -1;
            int pt = 0;
            FileReader fr = null;
            BufferedReader br = null;
            String libraryName = null;
            try {
                String buf;
                fr = new FileReader(f);
                br = new BufferedReader(fr);
                while ((buf = br.readLine()) != null) {
                    if (buf.matches("^\\[FIDOLIB .*\\]\\s*")) {
                        buf = buf.trim();
                        libraryName = buf.substring(9, buf.length() - 1);
                        break;
                    }
                    if (maxReadline != -1 && maxReadline <= pt) {
                        break;
                    }
                    ++pt;
                }
            }
            catch (Exception e) {
                libraryName = null;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("Problems while closing streams.");
                }
            }
            return libraryName;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        @Override
        public int getSize() {
            return this.libraryList.size();
        }

        @Override
        public LibraryDesc getElementAt(int index) {
            return this.libraryList.get(index);
        }
    }
}

