/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import graphic.swing.ColorSwing;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.JList;
import javax.swing.JPanel;
import layers.LayerDesc;

public class CellLayer
extends JPanel {
    private final JList list;
    private final boolean isSelected;
    private final LayerDesc layer;

    CellLayer(LayerDesc la, JList l, boolean is) {
        this.layer = la;
        this.list = l;
        this.isSelected = is;
        this.setPreferredSize(new Dimension(150, 18));
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.isSelected ? this.list.getSelectionBackground() : this.list.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        ColorSwing c = (ColorSwing)this.layer.getColor();
        g.setColor(c.getColorSwing());
        g.fillRect(2, 2, this.getHeight(), this.getHeight() - 4);
        if (this.layer.getVisible()) {
            if (this.isSelected) {
                g.setColor(this.isSelected ? this.list.getSelectionForeground() : this.list.getForeground());
            }
        } else {
            g.setColor(SystemColor.textInactiveText);
        }
        g.drawString(this.layer.getDescription(), 6 * this.getHeight() / 4, (int)(3.8 * (double)this.getHeight() / 5.0));
    }
}

