/*
 * Decompiled with CFR 0.152.
 */
package circuit.controllers;

import circuit.controllers.EditorActions;
import circuit.controllers.PrimitivesParInterface;
import circuit.controllers.UndoActions;
import circuit.model.DrawingModel;
import geom.MapCoordinates;
import java.util.Vector;
import layers.LayerDesc;
import primitives.GraphicPrimitive;
import primitives.PrimitiveMacro;

public class HandleActions {
    private final DrawingModel P;
    private final EditorActions edt;
    private final UndoActions ua;
    private boolean firstDrag;
    private GraphicPrimitive primBeingDragged;
    private int handleBeingDragged;
    private int opx;
    private int opy;
    private boolean hasMoved;
    private int oldpx;
    private int oldpy;

    public HandleActions(DrawingModel pp, EditorActions e, UndoActions u) {
        this.P = pp;
        this.edt = e;
        this.ua = u;
        this.firstDrag = false;
        this.handleBeingDragged = -1;
    }

    public void dragPrimitives(PrimitivesParInterface CC, int px, int py, MapCoordinates cs) {
        if (this.handleBeingDragged != -2) {
            return;
        }
        this.firstDrag = false;
        int dx = cs.unmapXsnap(px) - this.oldpx;
        int dy = cs.unmapYsnap(py) - this.oldpy;
        this.oldpx = cs.unmapXsnap(px);
        this.oldpy = cs.unmapXsnap(py);
        if (dx == 0 && dy == 0) {
            return;
        }
        for (int i = 0; i < this.P.getPrimitiveVector().size(); ++i) {
            this.primBeingDragged = this.P.getPrimitiveVector().get(i);
            if (!this.primBeingDragged.getSelected()) continue;
            if (this.primBeingDragged instanceof PrimitiveMacro) {
                ((PrimitiveMacro)this.primBeingDragged).setDrawOnlyLayer(-1);
            }
            this.primBeingDragged.setChanged(true);
            if (!this.firstDrag) {
                CC.forcesRepaint();
            }
            for (int j = 0; j < this.primBeingDragged.getControlPointNumber(); ++j) {
                this.primBeingDragged.virtualPoint[j].x += dx;
                this.primBeingDragged.virtualPoint[j].y += dy;
            }
        }
    }

    public void dragHandleStart(int px, int py, int tolerance, boolean multiple, MapCoordinates cs) {
        int mindistance;
        int isel = 0;
        int distance = mindistance = Integer.MAX_VALUE;
        this.hasMoved = false;
        Vector<LayerDesc> layerV = this.P.getLayers();
        this.oldpx = cs.unmapXnosnap(px);
        this.oldpy = cs.unmapXnosnap(py);
        this.firstDrag = true;
        int sptol = Math.abs(cs.unmapXnosnap(px + tolerance) - cs.unmapXnosnap(px));
        if (sptol < 2) {
            sptol = 2;
        }
        for (int i = 0; i < this.P.getPrimitiveVector().size(); ++i) {
            GraphicPrimitive gp = this.P.getPrimitiveVector().get(i);
            int layer = gp.getLayer();
            if (layer < layerV.size() && !layerV.get((int)layer).isVisible && !(gp instanceof PrimitiveMacro)) continue;
            if (gp.selectedState) {
                this.handleBeingDragged = gp.onHandle(cs, px, py);
                if (this.handleBeingDragged != -1) {
                    this.primBeingDragged = gp;
                    continue;
                }
            }
            if ((distance = gp.getDistanceToPoint(this.oldpx, this.oldpy)) > mindistance) continue;
            isel = i;
            mindistance = distance;
        }
        if (mindistance < sptol && this.handleBeingDragged < 0) {
            this.primBeingDragged = this.P.getPrimitiveVector().get(isel);
            if (!multiple && !this.primBeingDragged.getSelected()) {
                this.edt.setSelectionAll(false);
            }
            if (!multiple) {
                this.primBeingDragged.setSelected(true);
            }
            this.handleBeingDragged = -2;
            this.firstDrag = true;
            this.oldpx = cs.unmapXsnap(px);
            this.oldpy = cs.unmapXsnap(py);
        } else if (this.handleBeingDragged < 0) {
            this.oldpx = cs.unmapXsnap(px);
            this.oldpy = cs.unmapXsnap(py);
            this.handleBeingDragged = -3;
        }
    }

    public void dragHandleEnd(PrimitivesParInterface CC, int px, int py, boolean multiple, MapCoordinates cs) {
        CC.setEvidenceRect(0, 0, -1, -1);
        if (this.handleBeingDragged < 0) {
            if (this.handleBeingDragged == -3) {
                int xa = Math.min(this.oldpx, cs.unmapXnosnap(px));
                int ya = Math.min(this.oldpy, cs.unmapYnosnap(py));
                int xb = Math.max(this.oldpx, cs.unmapXnosnap(px));
                int yb = Math.max(this.oldpy, cs.unmapYnosnap(py));
                if (!multiple) {
                    this.edt.setSelectionAll(false);
                }
                this.edt.selectRect(xa, ya, xb - xa, yb - ya);
            }
            if (this.handleBeingDragged == -2 && this.hasMoved && this.ua != null) {
                this.ua.saveUndoState();
            }
            this.handleBeingDragged = -1;
            return;
        }
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].x = cs.unmapXsnap(px);
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].y = cs.unmapYsnap(py);
        this.handleBeingDragged = -1;
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public void dragHandleDrag(PrimitivesParInterface CC, int px, int py, MapCoordinates cs) {
        this.hasMoved = true;
        boolean flip = false;
        if (this.handleBeingDragged < 0) {
            if (this.handleBeingDragged == -2) {
                this.dragPrimitives(CC, px, py, cs);
            }
            if (this.handleBeingDragged == -3) {
                int xa = cs.mapXi(this.oldpx, this.oldpy, false);
                int ya = cs.mapYi(this.oldpx, this.oldpy, false);
                int xb = this.opx;
                int yb = this.opy;
                if (this.opx > xa && px < xa) {
                    flip = true;
                }
                if (this.opy > ya && py < ya) {
                    flip = true;
                }
                if (!this.firstDrag) {
                    int a = Math.min(xa, xb);
                    int b = Math.min(ya, yb);
                    int c = Math.abs(xb - xa);
                    int d = Math.abs(yb - ya);
                    xb = px;
                    yb = py;
                    this.opx = px;
                    this.opy = py;
                    CC.setEvidenceRect(Math.min(xa, xb), Math.min(ya, yb), Math.abs(xb - xa), Math.abs(yb - ya));
                    a = Math.min(a, Math.min(xa, xb));
                    b = Math.min(b, Math.min(ya, yb));
                    c = Math.max(c, Math.abs(xb - xa));
                    d = Math.max(d, Math.abs(yb - ya));
                    if (flip) {
                        CC.forcesRepaint();
                    } else {
                        CC.forcesRepaint(a, b, c + 10, d + 10);
                    }
                    return;
                }
                xb = px;
                yb = py;
                this.opx = px;
                this.opy = py;
                this.firstDrag = false;
            }
            return;
        }
        if (!this.firstDrag) {
            CC.forcesRepaint();
        }
        this.firstDrag = false;
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].x = cs.unmapXsnap(px);
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].y = cs.unmapYsnap(py);
        this.primBeingDragged.setChanged(true);
    }
}

