/*
 * Decompiled with CFR 0.152.
 */
package circuit.controllers;

import circuit.controllers.ParserActions;
import circuit.controllers.UndoActions;
import circuit.model.DrawingModel;
import geom.MapCoordinates;
import java.util.Vector;
import layers.LayerDesc;
import primitives.GraphicPrimitive;
import primitives.PrimitiveMacro;

public class EditorActions {
    public static final int SEL_TOLERANCE = 10;
    private final DrawingModel P;
    private final UndoActions ua;

    public EditorActions(DrawingModel pp, UndoActions u) {
        this.P = pp;
        this.ua = u;
    }

    public void rotateAllSelected() {
        int ix = 100;
        int iy = 100;
        boolean firstPrimitive = true;
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected()) continue;
            if (firstPrimitive) {
                ix = g.getFirstPoint().x;
                iy = g.getFirstPoint().y;
            }
            firstPrimitive = false;
            g.rotatePrimitive(false, ix, iy);
        }
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public void moveAllSelected(int dx, int dy) {
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected()) continue;
            g.movePrimitive(dx, dy);
        }
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public void mirrorAllSelected() {
        int ix = 100;
        boolean firstPrimitive = true;
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected()) continue;
            if (firstPrimitive) {
                ix = g.getFirstPoint().x;
            }
            firstPrimitive = false;
            g.mirrorPrimitive(ix);
        }
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public boolean selectRect(int px, int py, int w, int h) {
        boolean s = false;
        if (w < 1 || h < 1) {
            return false;
        }
        Vector<LayerDesc> layerV = this.P.getLayers();
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            int layer = g.getLayer();
            if (layer < layerV.size() && !layerV.get((int)layer).isVisible && !(g instanceof PrimitiveMacro) || !g.selectRect(px, py, w, h)) continue;
            s = true;
        }
        return s;
    }

    public GraphicPrimitive getFirstSelectedPrimitive() {
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected()) continue;
            return g;
        }
        return null;
    }

    public boolean isUniquePrimitiveSelected() {
        boolean isUnique = true;
        boolean hasFound = false;
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected()) continue;
            if (hasFound) {
                isUnique = false;
            }
            hasFound = true;
        }
        return hasFound && isUnique;
    }

    public boolean selectionCanBeSplitted() {
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected() || !(g instanceof PrimitiveMacro) && !g.hasName() && !g.hasValue()) continue;
            return true;
        }
        return false;
    }

    public boolean setLayerForSelectedPrimitives(int l) {
        boolean toRedraw = false;
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected() || g instanceof PrimitiveMacro) continue;
            g.setLayer(l);
            toRedraw = true;
        }
        if (toRedraw) {
            this.P.sortPrimitiveLayers();
            this.P.setChanged(true);
            this.ua.saveUndoState();
        }
        return toRedraw;
    }

    public int distancePrimitive(int px, int py) {
        int mindistance = Integer.MAX_VALUE;
        int layer = 0;
        Vector<LayerDesc> layerV = this.P.getLayers();
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            int distance = g.getDistanceToPoint(px, py);
            if (distance > mindistance) continue;
            layer = g.getLayer();
            if (!layerV.get((int)layer).isVisible) continue;
            mindistance = distance;
        }
        return mindistance;
    }

    public void handleSelection(MapCoordinates cs, int x, int y, boolean toggle) {
        int toll;
        if (!toggle) {
            this.setSelectionAll(false);
        }
        if ((toll = cs.unmapXnosnap(x + 10) - cs.unmapXnosnap(x)) < 2) {
            toll = 2;
        }
        this.selectPrimitive(cs.unmapXnosnap(x), cs.unmapYnosnap(y), toll, toggle);
    }

    private boolean selectPrimitive(int px, int py, int tolerance, boolean toggle) {
        int mindistance = Integer.MAX_VALUE;
        int isel = 0;
        Vector<LayerDesc> layerV = this.P.getLayers();
        Vector<GraphicPrimitive> v = this.P.getPrimitiveVector();
        for (int i = 0; i < this.P.getPrimitiveVector().size(); ++i) {
            int distance;
            int layer = v.get(i).getLayer();
            if (!layerV.get((int)layer).isVisible && !(v.get(i) instanceof PrimitiveMacro) || (distance = v.get(i).getDistanceToPoint(px, py)) > mindistance) continue;
            isel = i;
            mindistance = distance;
        }
        if (mindistance < tolerance) {
            GraphicPrimitive gp = v.get(isel);
            if (toggle) {
                boolean sel = gp.getSelected();
                gp.setSelected(!sel);
            } else {
                gp.setSelected(true);
            }
            return true;
        }
        return false;
    }

    public void setSelectionAll(boolean state) {
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            g.setSelected(state);
        }
    }

    public void deleteAllSelected(boolean saveState) {
        Vector<GraphicPrimitive> v = this.P.getPrimitiveVector();
        for (int i = 0; i < v.size(); ++i) {
            if (!v.get(i).getSelected()) continue;
            v.remove(v.get(i--));
        }
        if (saveState && this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public StringBuffer getSelectedString(boolean extensions, ParserActions pa) {
        StringBuffer s = new StringBuffer("[FIDOCAD]\n");
        s.append(pa.registerConfiguration(extensions));
        for (GraphicPrimitive g : this.P.getPrimitiveVector()) {
            if (!g.getSelected()) continue;
            s.append(g.toString(extensions));
        }
        return s;
    }
}

