/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.tube;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractComponent;
import org.diylc.components.semiconductors.SymbolFlipping;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class AbstractTubeSymbol
extends AbstractComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size PIN_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Color COLOR = Color.black;
    protected String value = "";
    protected Color color = COLOR;
    protected Display display = Display.NAME;
    protected transient Shape[] body;
    protected boolean showHeaters;
    protected Orientation orientation = Orientation.DEFAULT;
    protected SymbolFlipping flip = SymbolFlipping.NONE;
    protected Point[] controlPoints;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        if (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING) {
            finalColor = SELECTION_COLOR;
        } else if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalColor = theme.getOutlineColor();
        } else {
            finalColor = this.color;
        }
        g2d.setColor(finalColor);
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.draw(body[0]);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(body[1]);
        if (body[2] != null) {
            g2d.draw(body[2]);
        }
        g2d.setFont(project.getFont());
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR;
        }
        g2d.setColor(finalLabelColor);
        Rectangle rect = body[2] != null ? body[2].getBounds() : body[1].getBounds();
        String label = "";
        String string = label = this.display == Display.VALUE ? this.getValue() : this.getName();
        if (this.display == Display.NONE) {
            label = "";
        }
        if (this.display == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        StringUtils.drawCenteredText(g2d, label, rect.x + rect.width, rect.y + rect.height, HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM);
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        if (index == this.controlPoints.length - 1) {
            this.body = null;
        }
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty(name="Heaters")
    public boolean getShowHeaters() {
        return this.showHeaters;
    }

    public void setShowHeaters(boolean showHeaters) {
        this.showHeaters = showHeaters;
        this.body = null;
    }

    @EditableProperty
    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = Orientation.DEFAULT;
        }
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public SymbolFlipping getFlip() {
        if (this.flip == null) {
            this.flip = SymbolFlipping.NONE;
        }
        return this.flip;
    }

    public void setFlip(SymbolFlipping flip) {
        this.flip = flip;
        this.updateControlPoints();
        this.body = null;
    }

    protected abstract Shape[] initializeBody();

    protected Shape[] getBody() {
        if (this.body == null) {
            int i;
            AffineTransform tx;
            Shape[] newBody = this.initializeBody();
            int centerX = this.controlPoints[0].x;
            int centerY = this.controlPoints[0].y;
            if (this.getFlip() == SymbolFlipping.X) {
                tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                tx.concatenate(AffineTransform.getTranslateInstance(-2 * centerX, 0.0));
                if (newBody != null) {
                    for (i = 0; i < newBody.length; ++i) {
                        newBody[i] = tx.createTransformedShape(newBody[i]);
                    }
                }
            } else if (this.getFlip() == SymbolFlipping.Y) {
                tx = AffineTransform.getScaleInstance(1.0, -1.0);
                tx.concatenate(AffineTransform.getTranslateInstance(0.0, -2 * centerY));
                if (newBody != null) {
                    for (i = 0; i < newBody.length; ++i) {
                        newBody[i] = tx.createTransformedShape(newBody[i]);
                    }
                }
            }
            if (this.getOrientation() != Orientation.DEFAULT) {
                Point first = this.controlPoints[0];
                double angle = Double.parseDouble(this.getOrientation().name().replace("_", ""));
                AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(angle), first.x, first.y);
                if (newBody != null) {
                    for (int i2 = 0; i2 < newBody.length; ++i2) {
                        newBody[i2] = rotate.createTransformedShape(newBody[i2]);
                    }
                }
            }
            this.body = newBody;
        }
        return this.body;
    }

    protected abstract Point[] initializeControlPoints(Point var1);

    protected void updateControlPoints() {
        int i;
        AffineTransform tx;
        Point[] newPoints = this.initializeControlPoints(this.controlPoints[0]);
        this.controlPoints = newPoints;
        int centerX = this.controlPoints[0].x;
        int centerY = this.controlPoints[0].y;
        if (this.getFlip() == SymbolFlipping.X) {
            tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.concatenate(AffineTransform.getTranslateInstance(-2 * centerX, 0.0));
            for (i = 0; i < this.controlPoints.length; ++i) {
                tx.transform(this.controlPoints[i], this.controlPoints[i]);
            }
        } else if (this.getFlip() == SymbolFlipping.Y) {
            tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.concatenate(AffineTransform.getTranslateInstance(0.0, -2 * centerY));
            for (i = 0; i < this.controlPoints.length; ++i) {
                tx.transform(this.controlPoints[i], this.controlPoints[i]);
            }
        }
        if (this.getOrientation() == Orientation.DEFAULT) {
            return;
        }
        Point first = this.controlPoints[0];
        double angle = Double.parseDouble(this.getOrientation().name().replace("_", ""));
        AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(angle), first.x, first.y);
        for (int i2 = 1; i2 < this.controlPoints.length; ++i2) {
            rotate.transform(this.controlPoints[i2], this.controlPoints[i2]);
        }
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

