/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.smd;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class PassiveSMDComponent<T>
extends AbstractTransparentComponent<T> {
    private static final long serialVersionUID = 1L;
    public static Color PIN_COLOR = METAL_COLOR;
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color LABEL_COLOR = Color.white;
    public static int EDGE_RADIUS = 4;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.8), SizeUnit.mm);
    protected T value;
    private Orientation orientation = Orientation.DEFAULT;
    private SMDSize size = SMDSize._1206;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0)};
    protected Display display = Display.NAME;
    protected Color bodyColor;
    protected Color borderColor;
    private Color labelColor = LABEL_COLOR;
    private transient Area[] body;

    public PassiveSMDComponent() {
        this.updateControlPoints();
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.VALUE;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty
    public SMDSize getSize() {
        return this.size;
    }

    public void setSize(SMDSize size) {
        this.size = size;
        this.updateControlPoints();
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        int dy1;
        int dx1;
        Point firstPoint;
        this.controlPoints[0] = firstPoint = this.controlPoints[0];
        int pinSize = (int)PIN_SIZE.convertToPixels();
        int smdLength = (int)this.getSize().getLength().convertToPixels();
        int pinSpacing = smdLength - pinSize;
        switch (this.orientation) {
            case DEFAULT: {
                dx1 = 0;
                dy1 = pinSpacing;
                break;
            }
            case _90: {
                dx1 = -pinSpacing;
                dy1 = 0;
                break;
            }
            case _180: {
                dx1 = 0;
                dy1 = -pinSpacing;
                break;
            }
            case _270: {
                dx1 = pinSpacing;
                dy1 = 0;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected orientation: " + this.orientation);
            }
        }
        this.controlPoints[1] = new Point(firstPoint.x + dx1, firstPoint.y + dy1);
    }

    public Area[] getBody() {
        if (this.body == null) {
            int height;
            int width;
            this.body = new Area[2];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int smdWidth = (int)this.getSize().getWidth().convertToPixels();
            int smdLength = (int)this.getSize().getLength().convertToPixels();
            int pinSize = (int)PIN_SIZE.convertToPixels();
            switch (this.orientation) {
                case DEFAULT: {
                    width = smdWidth;
                    height = smdLength;
                    x = this.controlPoints[0].x - smdWidth / 2;
                    y = this.controlPoints[0].y - pinSize / 2;
                    break;
                }
                case _90: {
                    width = smdLength;
                    height = smdWidth;
                    x = this.controlPoints[1].x - pinSize / 2;
                    y = this.controlPoints[1].y - smdWidth / 2;
                    break;
                }
                case _180: {
                    width = smdWidth;
                    height = smdLength;
                    x = this.controlPoints[1].x - smdWidth / 2;
                    y = this.controlPoints[1].y - pinSize / 2;
                    break;
                }
                case _270: {
                    width = smdLength;
                    height = smdWidth;
                    x = this.controlPoints[0].x - pinSize / 2;
                    y = this.controlPoints[0].y - smdWidth / 2;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            Area mainArea = new Area(new RoundRectangle2D.Double(x, y, width, height, EDGE_RADIUS, EDGE_RADIUS));
            Area contactArea = new Area();
            if (width > height) {
                contactArea.add(new Area(new Rectangle2D.Double(x, y, pinSize, height)));
                contactArea.add(new Area(new Rectangle2D.Double(x + width - pinSize, y, pinSize, height)));
            } else {
                contactArea.add(new Area(new Rectangle2D.Double(x, y, width, pinSize)));
                contactArea.add(new Area(new Rectangle2D.Double(x, y + height - pinSize, width, pinSize)));
            }
            contactArea.intersect(mainArea);
            mainArea.subtract(contactArea);
            this.body[0] = mainArea;
            this.body[1] = contactArea;
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area mainArea = this.getBody()[0];
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBodyColor());
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getBorderColor();
        }
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(mainArea);
        Area contactArea = this.getBody()[1];
        if (!outlineMode) {
            g2d.setColor(PIN_COLOR);
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.fill(contactArea);
            g2d.setComposite(oldComposite);
        }
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : PIN_BORDER_COLOR;
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(contactArea);
        g2d.setFont(project.getFont());
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor();
        }
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        String label = "";
        String string = label = this.getDisplay() == Display.NAME ? this.getName() : this.getValue().toString();
        if (this.getDisplay() == Display.NONE) {
            label = "";
        }
        if (this.getDisplay() == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        Rectangle textTarget = mainArea.getBounds();
        int length = textTarget.height > textTarget.width ? textTarget.height : textTarget.width;
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        do {
            g2d.setFont(g2d.getFont().deriveFont(g2d.getFont().getSize2D() - 1.0f));
            fontMetrics = g2d.getFontMetrics(g2d.getFont());
            rect = fontMetrics.getStringBounds(label, g2d);
            textHeight = (int)rect.getHeight();
        } while ((textWidth = (int)rect.getWidth()) > length && g2d.getFont().getSize2D() > 2.0f);
        double centerX = textTarget.getX() + textTarget.getWidth() / 2.0;
        double centerY = textTarget.getY() + textTarget.getHeight() / 2.0;
        g2d.translate(centerX, centerY);
        switch (this.orientation) {
            case DEFAULT: {
                g2d.rotate(1.5707963267948966);
                break;
            }
            case _90: {
                g2d.rotate(Math.PI);
                break;
            }
            case _180: {
                g2d.rotate(4.71238898038469);
                break;
            }
            case _270: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected orientation: " + this.orientation);
            }
        }
        int x = -textWidth / 2;
        int y = -textHeight / 2 + fontMetrics.getAscent() - 1;
        g2d.drawString(label, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int radius = 4 * width / 32;
        int contactSize = 4 * width / 32;
        int thickness = this.getClosestOdd(width / 2);
        g2d.rotate(0.7853981633974483, width / 2, height / 2);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double((width - thickness) / 2, 4 * width / 32, thickness, height - 8 * width / 32, radius, radius);
        g2d.setColor(this.getBodyColor());
        g2d.fill(rect);
        g2d.setColor(this.getBorderColor());
        g2d.draw(rect);
        Area contactArea = new Area();
        contactArea.add(new Area(new Rectangle2D.Double((width - thickness) / 2, 4 * width / 32, thickness, contactSize)));
        contactArea.add(new Area(new Rectangle2D.Double((width - thickness) / 2, height - 8 * width / 32, thickness, contactSize)));
        contactArea.intersect(new Area(rect));
        g2d.setColor(PIN_COLOR);
        g2d.fill(contactArea);
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public static enum SMDSize {
        _0805(new Size(Double.valueOf(0.05), SizeUnit.in), new Size(Double.valueOf(0.08), SizeUnit.in)),
        _1206(new Size(Double.valueOf(1.6), SizeUnit.mm), new Size(Double.valueOf(3.2), SizeUnit.mm)),
        _1210(new Size(Double.valueOf(2.5), SizeUnit.mm), new Size(Double.valueOf(3.2), SizeUnit.mm)),
        _1806(new Size(Double.valueOf(1.6), SizeUnit.mm), new Size(Double.valueOf(4.5), SizeUnit.mm)),
        _1812(new Size(Double.valueOf(3.2), SizeUnit.mm), new Size(Double.valueOf(4.5), SizeUnit.mm));

        private Size width;
        private Size length;

        private SMDSize(Size width, Size length) {
            this.width = width;
            this.length = length;
        }

        public Size getWidth() {
            return this.width;
        }

        public Size getLength() {
            return this.length;
        }

        public String toString() {
            return this.name().replace("_", "");
        }

        public int getValue() {
            return Integer.parseInt(this.toString());
        }
    }
}

