/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.shapes;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.shapes.AbstractShape;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;

@ComponentDescriptor(name="Ellipse", author="Branislav Stojkovic", category="Shapes", instanceNamePrefix="ELL", description="Elliptical area", zOrder=4.0, flexibleZOrder=true, bomPolicy=BomPolicy.SHOW_ALL_NAMES, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class Ellipse
extends AbstractShape {
    private static final long serialVersionUID = 1L;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)((int)this.borderThickness.convertToPixels())));
        float alpha = this.alpha;
        if (componentState == ComponentState.DRAGGING) {
            alpha = 0.0f;
        }
        Composite oldComposite = g2d.getComposite();
        if (alpha < (float)MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(this.color);
        g2d.fillOval(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
        g2d.setComposite(oldComposite);
        drawingObserver.stopTracking();
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.drawOval(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(COLOR);
        g2d.fillOval(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
    }
}

