/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.TwoCircleTangent;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Transistor (TO-3)", author="Branislav Stojkovic", category="Semiconductors", instanceNamePrefix="Q", description="Transistor with large metal body", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE)
public class TransistorTO3
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.lightGray;
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color LABEL_COLOR = Color.black;
    public static Size LARGE_DIAMETER = new Size(Double.valueOf(26.2), SizeUnit.mm);
    public static Size INNER_DIAMETER = new Size(Double.valueOf(21.3), SizeUnit.mm);
    public static Size SMALL_DIAMETER = new Size(Double.valueOf(8.0), SizeUnit.mm);
    public static Size HOLE_DISTANCE = new Size(Double.valueOf(30.1), SizeUnit.mm);
    public static Size HOLE_SIZE = new Size(Double.valueOf(4.1), SizeUnit.mm);
    public static Size PIN_SPACING = new Size(Double.valueOf(10.9), SizeUnit.mm);
    public static Size PIN_OFFSET = new Size(Double.valueOf(1.85), SizeUnit.mm);
    public static Size PIN_DIAMETER = new Size(Double.valueOf(1.0), SizeUnit.mm);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0)};
    private transient Area[] body;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;
    protected Display display = Display.NAME;

    public TransistorTO3() {
        this.updateControlPoints();
        this.alpha = (byte)100;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        switch (this.orientation) {
            case DEFAULT: {
                this.controlPoints[1].setLocation(x, y + pinSpacing);
                break;
            }
            case _90: {
                this.controlPoints[1].setLocation(x - pinSpacing, y);
                break;
            }
            case _180: {
                this.controlPoints[1].setLocation(x, y - pinSpacing);
                break;
            }
            case _270: {
                this.controlPoints[1].setLocation(x + pinSpacing, y);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected orientation: " + this.orientation);
            }
        }
    }

    public Area[] getBody() {
        if (this.body == null) {
            this.body = new Area[2];
            int pinOffset = (int)PIN_OFFSET.convertToPixels();
            int x = (this.controlPoints[0].x + this.controlPoints[1].x) / 2;
            int y = (this.controlPoints[0].y + this.controlPoints[1].y) / 2;
            switch (this.orientation) {
                case DEFAULT: {
                    x += pinOffset;
                    break;
                }
                case _90: {
                    y += pinOffset;
                    break;
                }
                case _180: {
                    x -= pinOffset;
                    break;
                }
                case _270: {
                    y -= pinOffset;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            int largeDiameter = this.getClosestOdd(LARGE_DIAMETER.convertToPixels());
            int innerDiameter = this.getClosestOdd(INNER_DIAMETER.convertToPixels());
            int smallDiameter = this.getClosestOdd(SMALL_DIAMETER.convertToPixels());
            int holeDistance = this.getClosestOdd(HOLE_DISTANCE.convertToPixels());
            int holeSize = this.getClosestOdd(HOLE_SIZE.convertToPixels());
            TwoCircleTangent left = new TwoCircleTangent(new Point2D.Double(x, y), new Point2D.Double(x - holeDistance / 2, y), largeDiameter / 2, smallDiameter / 2);
            TwoCircleTangent right = new TwoCircleTangent(new Point2D.Double(x, y), new Point2D.Double(x + holeDistance / 2, y), largeDiameter / 2, smallDiameter / 2);
            this.body[0] = left;
            this.body[0].add(right);
            this.body[0].subtract(new Area(new Ellipse2D.Double(x - holeDistance / 2 - holeSize / 2, y - holeSize / 2, holeSize, holeSize)));
            this.body[0].subtract(new Area(new Ellipse2D.Double(x + holeDistance / 2 - holeSize / 2, y - holeSize / 2, holeSize, holeSize)));
            switch (this.orientation) {
                case DEFAULT: {
                    break;
                }
                case _90: {
                    this.body[0].transform(AffineTransform.getRotateInstance(1.5707963267948966, x, y));
                    break;
                }
                case _180: {
                    this.body[0].transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                    break;
                }
                case _270: {
                    this.body[0].transform(AffineTransform.getRotateInstance(4.71238898038469, x, y));
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.body[1] = new Area(new Ellipse2D.Double(x - innerDiameter / 2, y - innerDiameter / 2, innerDiameter, innerDiameter));
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSize = (int)PIN_DIAMETER.convertToPixels() / 2 * 2;
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        for (Point point : this.controlPoints) {
            if (!outlineMode) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
            g2d.setColor(outlineMode ? theme.getOutlineColor() : PIN_BORDER_COLOR);
            g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
        }
        Area mainArea = this.getBody()[0];
        Area innerArea = this.getBody()[1];
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(mainArea);
        g2d.draw(innerArea);
        g2d.setFont(project.getFont());
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor());
        g2d.setColor(finalLabelColor);
        String label = "";
        String string = label = this.getDisplay() == Display.NAME ? this.getName() : this.getValue();
        if (this.getDisplay() == Display.NONE) {
            label = "";
        }
        if (this.getDisplay() == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        Rectangle bounds = mainArea.getBounds();
        int x = bounds.x + (bounds.width - textWidth) / 2;
        int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int largeR = this.getClosestOdd((double)width * 3.0 / 8.0);
        int smallR = this.getClosestOdd((double)width / 6.0);
        int innerD = this.getClosestOdd((double)width / 2.0);
        int hole = 4 * width / 32;
        TwoCircleTangent area = new TwoCircleTangent(new Point2D.Double((double)width * 0.5, (double)height * 0.5), new Point2D.Double(width / 2, (double)height / 8.0), largeR, smallR);
        area.add(new TwoCircleTangent(new Point2D.Double((double)width * 0.5, (double)height * 0.5), new Point2D.Double(width / 2, (double)(height * 7) / 8.0), largeR, smallR));
        area.subtract(new Area(new Ellipse2D.Double((width - hole) / 2, height / 8 - hole / 2, hole, hole)));
        area.subtract(new Area(new Ellipse2D.Double((width - hole) / 2, height * 7 / 8 - hole / 2, hole, hole)));
        area.transform(AffineTransform.getRotateInstance(0.7853981633974483, width / 2, height / 2));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(area);
        g2d.drawOval((width - innerD) / 2, (height - innerD) / 2, innerD, innerD);
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.NAME;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }
}

