/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.components.semiconductors.AbstractTransistorPackage;
import org.diylc.components.transform.TO1Transformer;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Transistor (TO-1)", author="Branislav Stojkovic", category="Semiconductors", instanceNamePrefix="Q", description="Transistor with small metal body", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE, transformer=TO1Transformer.class)
public class TransistorTO1
extends AbstractTransistorPackage {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.lightGray;
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color LABEL_COLOR = Color.black;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.03), SizeUnit.in);
    public static Size PIN_SPACING = new Size(Double.valueOf(0.05), SizeUnit.in);
    public static Size BODY_DIAMETER = new Size(Double.valueOf(0.24), SizeUnit.in);
    public static Size BODY_LENGTH = new Size(Double.valueOf(0.4), SizeUnit.in);
    public static Size EDGE_RADIUS = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private boolean folded = false;
    private Size pinSpacing = PIN_SPACING;

    public TransistorTO1() {
        this.updateControlPoints();
        this.alpha = (byte)100;
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    @Override
    protected void updateControlPoints() {
        int pinSpacing = (int)this.getPinSpacing().convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        switch (this.orientation) {
            case DEFAULT: {
                this.controlPoints[1].setLocation(x - (this.folded ? 0 : pinSpacing), y + pinSpacing);
                this.controlPoints[2].setLocation(x, y + 2 * pinSpacing);
                break;
            }
            case _90: {
                this.controlPoints[1].setLocation(x - pinSpacing, y - (this.folded ? 0 : pinSpacing));
                this.controlPoints[2].setLocation(x - 2 * pinSpacing, y);
                break;
            }
            case _180: {
                this.controlPoints[1].setLocation(x + (this.folded ? 0 : pinSpacing), y - pinSpacing);
                this.controlPoints[2].setLocation(x, y - 2 * pinSpacing);
                break;
            }
            case _270: {
                this.controlPoints[1].setLocation(x + pinSpacing, y + (this.folded ? 0 : pinSpacing));
                this.controlPoints[2].setLocation(x + 2 * pinSpacing, y);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected orientation: " + this.orientation);
            }
        }
    }

    public Area[] getBody() {
        block6: {
            Area newBody;
            block8: {
                int bodyDiameter;
                int y;
                int x;
                block7: {
                    if (this.body != null) break block6;
                    x = (this.controlPoints[0].x + this.controlPoints[1].x + this.controlPoints[2].x) / 3;
                    y = (this.controlPoints[0].y + this.controlPoints[1].y + this.controlPoints[2].y) / 3;
                    bodyDiameter = this.getClosestOdd(BODY_DIAMETER.convertToPixels());
                    int bodyLength = this.getClosestOdd(BODY_LENGTH.convertToPixels());
                    int edgeRadius = (int)EDGE_RADIUS.convertToPixels();
                    newBody = null;
                    if (!this.folded) break block7;
                    switch (this.orientation) {
                        case DEFAULT: {
                            newBody = new Area(new RoundRectangle2D.Double(x - bodyLength, y - bodyDiameter / 2, bodyLength, bodyDiameter, edgeRadius, edgeRadius));
                            newBody.add(new Area(new Rectangle2D.Double(x - bodyLength / 2, y - bodyDiameter / 2, bodyLength / 2, bodyDiameter)));
                            break block8;
                        }
                        case _90: {
                            newBody = new Area(new RoundRectangle2D.Double(x - bodyDiameter / 2, y - bodyLength, bodyDiameter, bodyLength, edgeRadius, edgeRadius));
                            newBody.add(new Area(new Rectangle2D.Double(x - bodyDiameter / 2, y - bodyLength / 2, bodyDiameter, bodyLength / 2)));
                            break block8;
                        }
                        case _180: {
                            newBody = new Area(new RoundRectangle2D.Double(x, y - bodyDiameter / 2, bodyLength, bodyDiameter, edgeRadius, edgeRadius));
                            newBody.add(new Area(new Rectangle2D.Double(x, y - bodyDiameter / 2, bodyLength / 2, bodyDiameter)));
                            break block8;
                        }
                        case _270: {
                            newBody = new Area(new RoundRectangle2D.Double(x - bodyDiameter / 2, y, bodyDiameter, bodyLength, edgeRadius, edgeRadius));
                            newBody.add(new Area(new Rectangle2D.Double(x - bodyDiameter / 2, y, bodyDiameter, bodyLength / 2)));
                            break block8;
                        }
                        default: {
                            throw new RuntimeException("Unexpected orientation: " + this.orientation);
                        }
                    }
                }
                newBody = new Area(new Ellipse2D.Double(x - bodyDiameter / 2, y - bodyDiameter / 2, bodyDiameter, bodyDiameter));
            }
            this.body = new Area[]{newBody};
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        for (Point point : this.controlPoints) {
            if (!outlineMode) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
            g2d.setColor(outlineMode ? theme.getOutlineColor() : PIN_BORDER_COLOR);
            g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
        }
        Area mainArea = this.getBody()[0];
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(mainArea);
        g2d.setFont(project.getFont());
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor());
        g2d.setColor(finalLabelColor);
        String label = "";
        String string = label = this.getDisplay() == Display.NAME ? this.getName() : this.getValue();
        if (this.getDisplay() == Display.NONE) {
            label = "";
        }
        if (this.getDisplay() == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        Rectangle bounds = mainArea.getBounds();
        int x = bounds.x + (bounds.width - textWidth) / 2;
        int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = (int)(2.0f * (float)width / 32.0f);
        Area area = new Area(new Ellipse2D.Double(margin / 2, margin, width - 2 * margin, width - 2 * margin));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(area);
        g2d.setColor(PIN_COLOR);
        int pinSize = 2 * width / 32;
        for (int i = 0; i < 3; ++i) {
            g2d.fillOval((i == 1 ? width * 3 / 8 : width / 2) - pinSize / 2, height / 4 * (i + 1), pinSize, pinSize);
        }
    }

    @EditableProperty
    public boolean getFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Pin spacing")
    public Size getPinSpacing() {
        return this.pinSpacing;
    }

    public void setPinSpacing(Size pinSpacing) {
        this.pinSpacing = pinSpacing;
        this.updateControlPoints();
        this.body = null;
    }
}

