/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.semiconductors.DiodeSymbol;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.KeywordPolicy;

@ComponentDescriptor(name="Photo Diode", author="N9XYP", category="Schematic Symbols", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="D", description="Photo Diode schematic symbol", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Schematic", transformer=SimpleComponentTransformer.class)
public class PhotoDiodeSymbol
extends DiodeSymbol {
    private static final long serialVersionUID = 1L;

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        super.decorateComponentBody(g2d, outlineMode);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        double width = this.getWidth().convertToPixels();
        double arrowLength = width / 3.0;
        double arrowSize = width / 6.0;
        int d = (int)(width / 3.0);
        int x2 = (int)((double)(d / 2) + Math.cos(0.7853981633974483) * arrowLength);
        int y2 = (int)(width + Math.sin(0.7853981633974483) * arrowLength);
        g2d.drawLine(d / 2, (int)width, x2, y2);
        g2d.fillPolygon(new Polygon(new int[]{d / 2, (int)((double)(d / 2) + arrowSize), d / 2}, new int[]{(int)width, (int)width, (int)(width + arrowSize)}, 3));
        x2 = (int)((double)(3 * d / 2) + Math.cos(0.7853981633974483) * arrowLength);
        y2 = (int)(width + Math.sin(0.7853981633974483) * arrowLength);
        g2d.drawLine(3 * d / 2, (int)width, x2, y2);
        g2d.fillPolygon(new Polygon(new int[]{3 * d / 2, (int)((double)(3 * d / 2) + arrowSize), 3 * d / 2}, new int[]{(int)width, (int)width, (int)(width + arrowSize)}, 3));
    }

    @Override
    public void drawIcon(Graphics2D g2d, int width, int height) {
        AffineTransform tx = g2d.getTransform();
        super.drawIcon(g2d, width, height);
        int arrowSize = 3 * width / 32;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setTransform(tx);
        g2d.drawLine(width * 9 / 16, height * 10 / 16, width * 9 / 16 + arrowSize, height * 10 / 16);
        g2d.drawLine(width * 9 / 16, height * 11 / 16, width * 9 / 16 + arrowSize, height * 11 / 16);
    }
}

