/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="LED", author="Branislav Stojkovic", category="Semiconductors", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="D", description="Light Emitting Diode", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class LED
extends AbstractLeadedComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_SIZE = new Size(Double.valueOf(5.0), SizeUnit.mm);
    public static Color BODY_COLOR = Color.decode("#5DFC0A");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    private String value = "";

    public LED() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR_ICON);
        g2d.drawLine(0, height / 2, width, height / 2);
        int margin = 4 * width / 32;
        Area area = new Area(new Ellipse2D.Double(margin, margin, width - 2 * margin, width - 2 * margin));
        area.intersect(new Area(new Rectangle2D.Double(margin, margin, width - 5 * margin / 2, width - 2 * margin)));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(area);
        g2d.drawOval(margin * 2 - 1, margin * 2 - 1, width - 4 * margin + 2, width - 4 * margin + 2);
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_SIZE;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_SIZE;
    }

    @Override
    protected Shape getBodyShape() {
        int size = this.getClosestOdd((int)(this.getLength().convertToPixels() * 1.2));
        Area area = new Area(new Ellipse2D.Double(0.0, 0.0, size, size));
        area.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, this.getLength().convertToPixels() * 1.15, size)));
        return area;
    }

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        if (!outlineMode) {
            int size = this.getClosestOdd((int)(this.getLength().convertToPixels() * 1.2));
            int innerSize = this.getClosestOdd(this.getLength().convertToPixels());
            int x = (size - innerSize) / 2;
            Ellipse2D.Double s = new Ellipse2D.Double(x, x, innerSize, innerSize);
            g2d.setColor(this.getBorderColor());
            g2d.draw(s);
        }
    }

    @Override
    @EditableProperty(name="Size")
    public Size getLength() {
        return super.getLength();
    }

    @Override
    public Size getWidth() {
        return super.getWidth();
    }
}

