/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.CreationMethod;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Transformer Core", author="Branislav Stojkovic", category="Schematic Symbols", instanceNamePrefix="T", description="Transformer core symbol. Use multiple instances together with \"Transformer Coil Symbol\"<br>to draw transformer schematics.", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_TAG, creationMethod=CreationMethod.POINT_BY_POINT, keywordTag="Schematic")
public class TransformerCore
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size SPACING = new Size(Double.valueOf(0.025), SizeUnit.in);
    public static Color COLOR = Color.blue;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0)};
    protected Color color = COLOR;

    public int getControlPointCount() {
        return 2;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        if (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING) {
            finalColor = SELECTION_COLOR;
        } else if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalColor = theme.getOutlineColor();
        } else {
            finalColor = this.color;
        }
        double theta = Math.atan2(this.controlPoints[1].y - this.controlPoints[0].y, this.controlPoints[1].x - this.controlPoints[0].x) + 1.5707963267948966;
        double spacing = SPACING.convertToPixels();
        g2d.setColor(finalColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.translate(spacing * Math.cos(theta) / 2.0, spacing * Math.sin(theta) / 2.0);
        g2d.drawLine(this.controlPoints[0].x, this.controlPoints[0].y, this.controlPoints[1].x, this.controlPoints[1].y);
        g2d.translate(-spacing * Math.cos(theta), -spacing * Math.sin(theta));
        g2d.drawLine(this.controlPoints[0].x, this.controlPoints[0].y, this.controlPoints[1].x, this.controlPoints[1].y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(COLOR);
        GeneralPath polyline = new GeneralPath();
        polyline.moveTo(0.0f, height * 7 / 16);
        polyline.lineTo(width, height * 7 / 16);
        polyline.moveTo(0.0f, height * 9 / 16);
        polyline.lineTo(width, height * 9 / 16);
        g2d.draw(polyline);
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

