/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Inductance;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Toroidal Inductor", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="L", description="Ferrite core torroidal inductor mounted vertically", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class ToroidalInductor
extends AbstractLeadedComponent<Inductance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(8.0), SizeUnit.mm);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(14.0), SizeUnit.mm);
    public static Color BODY_COLOR = Color.darkGray;
    public static Color LABEL_COLOR = Color.white;
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static int BAND_SPACING = 5;
    public static int FIRST_BAND = -4;
    private Inductance value = null;
    private Resistance resistance = null;

    public ToroidalInductor() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
        this.leadColor = COPPER_COLOR;
        this.labelColor = LABEL_COLOR;
    }

    @Override
    protected boolean supportsStandingMode() {
        return false;
    }

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Inductance getValue() {
        return this.value;
    }

    public void setValue(Inductance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString();
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(COPPER_COLOR);
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setColor(BODY_COLOR);
        Rectangle2D.Double a = new Rectangle2D.Double(width / 2 - 5, 6.0, 10.0, height - 14);
        g2d.fill(a);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(a);
        g2d.setColor(COPPER_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        for (int i = 0; i < 9; ++i) {
            g2d.drawLine(width / 2 - 5, 7 + 2 * i, width / 2 + 5, 7 + 2 * i);
        }
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_HEIGHT;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_WIDTH;
    }

    @Override
    protected Shape getBodyShape() {
        double width = this.getWidth().convertToPixels();
        double length = this.getLength().convertToPixels();
        return new RoundRectangle2D.Double(0.0, 0.0, length, this.getClosestOdd(width), length / 4.0, length / 4.0);
    }

    @Override
    protected boolean decorateAboveBorder() {
        return true;
    }

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        if (outlineMode) {
            return;
        }
        Area body = new Area(this.getBodyShape());
        int leadThickness = (int)this.getLeadThickness();
        Stroke stroke = ObjectCache.getInstance().fetchBasicStroke((float)(leadThickness / 2));
        Rectangle rect = body.getBounds();
        Area copper = new Area();
        for (double y = (double)(leadThickness / 2); y < (double)rect.height; y += (double)leadThickness * 0.9) {
            double margin = y < (double)leadThickness || y > (double)(rect.height - leadThickness) ? (double)(-leadThickness / 4) : (double)(leadThickness / 4);
            Line2D.Double line = new Line2D.Double(-margin, y, (double)rect.width + margin, y);
            Shape s = stroke.createStrokedShape(line);
            copper.add(new Area(s));
        }
        g2d.setColor(COPPER_COLOR);
        g2d.fill(copper);
        g2d.setColor(COPPER_COLOR.darker());
        g2d.draw(copper);
    }

    @Override
    @Deprecated
    public boolean getFlipStanding() {
        return super.getFlipStanding();
    }

    @EditableProperty
    public Resistance getResistance() {
        return this.resistance;
    }

    public void setResistance(Resistance resistance) {
        this.resistance = resistance;
    }
}

