/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractRadialComponent;
import org.diylc.components.passive.Voltage;
import org.diylc.core.CreationMethod;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Electrolytic Capacitor (Radial)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="C", description="Vertically mounted electrolytic capacitor, polarized or bipolar", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class RadialElectrolytic
extends AbstractRadialComponent<Capacitance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_SIZE = new Size(Double.valueOf(0.25), SizeUnit.in);
    public static Color BODY_COLOR = Color.decode("#6B6DCE");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static Color MARKER_COLOR = Color.decode("#8CACEA");
    public static Color TICK_COLOR = Color.white;
    public static Size HEIGHT = new Size(Double.valueOf(0.4), SizeUnit.in);
    public static Size EDGE_RADIUS = new Size(Double.valueOf(1.0), SizeUnit.mm);
    private Capacitance value = null;
    @Deprecated
    private Voltage voltage = Voltage._63V;
    private org.diylc.core.measures.Voltage voltageNew = null;
    private Color markerColor = MARKER_COLOR;
    private Color tickColor = TICK_COLOR;
    private boolean polarized = true;
    private boolean folded = false;
    private Size height = HEIGHT;
    private boolean invert = false;

    public RadialElectrolytic() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
        this.labelColor = TICK_COLOR;
    }

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Capacitance getValue() {
        return this.value;
    }

    public void setValue(Capacitance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getVoltageNew() == null ? "" : " " + this.getVoltageNew().toString());
    }

    @Deprecated
    public Voltage getVoltage() {
        return this.voltage;
    }

    @Deprecated
    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    @EditableProperty(name="Voltage")
    public org.diylc.core.measures.Voltage getVoltageNew() {
        return this.voltageNew;
    }

    public void setVoltageNew(org.diylc.core.measures.Voltage voltageNew) {
        this.voltageNew = voltageNew;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(BODY_COLOR);
        int margin = 3;
        Ellipse2D.Double body = new Ellipse2D.Double(margin, margin, this.getClosestOdd(width - 2 * margin), this.getClosestOdd(width - 2 * margin));
        g2d.fill(body);
        Area marker = new Area(body);
        marker.subtract(new Area(new Rectangle2D.Double(margin, margin, width - 4 * margin, this.getClosestOdd(width - 2 * margin))));
        g2d.setColor(MARKER_COLOR);
        g2d.fill(marker);
        g2d.setColor(TICK_COLOR);
        g2d.drawLine(width - 2 * margin, height / 2 - 2, width - 2 * margin, height / 2 + 2);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(body);
    }

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        int height = (int)this.getHeight().convertToPixels();
        if (this.polarized) {
            Color finalTickColor;
            int totalDiameter = this.getClosestOdd(this.getLength().convertToPixels());
            if (!outlineMode) {
                Area area;
                if (this.folded) {
                    area = new Area(this.getBodyShape());
                    if (this.invert) {
                        area.subtract(new Area(new Rectangle2D.Double((double)totalDiameter * 0.2, -height, totalDiameter, height * 2)));
                    } else {
                        area.subtract(new Area(new Rectangle2D.Double(0.0, -height, (double)totalDiameter * 0.8, height * 2)));
                    }
                    g2d.setColor(this.markerColor);
                    g2d.fill(area);
                } else {
                    area = new Area(this.getBodyShape());
                    if (this.invert) {
                        area.subtract(new Area(new Rectangle2D.Double((double)totalDiameter * 0.2, 0.0, totalDiameter, totalDiameter)));
                    } else {
                        area.subtract(new Area(new Rectangle2D.Double(0.0, 0.0, (double)totalDiameter * 0.8, totalDiameter)));
                    }
                    g2d.setColor(this.markerColor);
                    g2d.fill(area);
                }
            }
            if (outlineMode) {
                Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
                finalTickColor = theme.getOutlineColor();
            } else {
                finalTickColor = this.tickColor;
            }
            g2d.setColor(finalTickColor);
            g2d.setStroke(ObjectCache.getInstance().fetchZoomableStroke(1.0f));
            if (this.folded) {
                int tickLength = height / 7;
                for (int i = 0; i < 3; ++i) {
                    g2d.drawLine((int)((double)totalDiameter * (this.invert ? 0.08 : 0.92)), -height / 2 + tickLength + i * tickLength * 2, (int)((double)totalDiameter * (this.invert ? 0.08 : 0.92)), -height / 2 + tickLength + i * tickLength * 2 + tickLength);
                }
            } else {
                g2d.drawLine((int)((double)totalDiameter * (this.invert ? 0.1 : 0.9)), totalDiameter / 2 - (int)((double)totalDiameter * 0.06), (int)((double)totalDiameter * (this.invert ? 0.1 : 0.9)), totalDiameter / 2 + (int)((double)totalDiameter * 0.06));
            }
        }
    }

    @Override
    protected Size getDefaultWidth() {
        return null;
    }

    @Override
    public Size getWidth() {
        return super.getWidth();
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_SIZE;
    }

    @Override
    @EditableProperty(name="Diameter")
    public Size getLength() {
        return super.getLength();
    }

    @EditableProperty(name="Marker")
    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Color coverColor) {
        this.markerColor = coverColor;
    }

    @EditableProperty(name="Tick")
    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color tickColor) {
        this.tickColor = tickColor;
    }

    @EditableProperty(name="Polarized")
    public boolean getPolarized() {
        return this.polarized;
    }

    public void setPolarized(boolean polarized) {
        this.polarized = polarized;
    }

    @EditableProperty
    public boolean getFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
    }

    @EditableProperty
    public Size getHeight() {
        if (this.height == null) {
            this.height = HEIGHT;
        }
        return this.height;
    }

    public void setHeight(Size height) {
        this.height = height;
    }

    @EditableProperty(name="Invert polarity")
    public boolean getInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    @Override
    protected Shape getBodyShape() {
        double height = (int)this.getHeight().convertToPixels();
        double diameter = (int)this.getLength().convertToPixels();
        if (this.folded) {
            return new RoundRectangle2D.Double(0.0, -height / 2.0 - LEAD_THICKNESS.convertToPixels() / 2.0, this.getClosestOdd(diameter), this.getClosestOdd(height), EDGE_RADIUS.convertToPixels(), EDGE_RADIUS.convertToPixels());
        }
        return new Ellipse2D.Double(0.0, 0.0, this.getClosestOdd(diameter), this.getClosestOdd(diameter));
    }
}

