/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractMultiPartComponent;
import org.diylc.components.transform.DIL_ICTransformer;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Audio Transformer", author="Branislav Stojkovic", category="Passive", instanceNamePrefix="TR", description="Small signal audio transformer with EI core", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE, transformer=DIL_ICTransformer.class)
public class AudioTransformer
extends AbstractMultiPartComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color CORE_COLOR = METAL_COLOR;
    public static Color CORE_BORDER_COLOR = CORE_COLOR.darker();
    public static Color COIL_COLOR = Color.decode("#DDDDDD");
    public static Color COIL_BORDER_COLOR = COIL_COLOR.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color LABEL_COLOR = Color.white;
    public static int EDGE_RADIUS = 6;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.03), SizeUnit.in);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private Size leadSpacing = new Size(Double.valueOf(0.1), SizeUnit.in);
    private Size windingSpacing = new Size(Double.valueOf(0.5), SizeUnit.in);
    private Size coreThickness = new Size(Double.valueOf(0.15), SizeUnit.in);
    private Size coreWidth = new Size(Double.valueOf(0.6), SizeUnit.in);
    private Size coilWidth = new Size(Double.valueOf(0.5), SizeUnit.in);
    private Size coilLength = new Size(Double.valueOf(0.6), SizeUnit.in);
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    protected Display display = Display.BOTH;
    private Color coreColor = CORE_COLOR;
    private Color coreBorderColor = CORE_BORDER_COLOR;
    private Color coilColor = COIL_COLOR;
    private Color coilBorderColor = COIL_BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;
    private boolean primaryCT = true;
    private boolean secondaryCT = true;
    private transient Area[] body;

    public AudioTransformer() {
        this.updateControlPoints();
        this.alpha = (byte)100;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Lead Spacing", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getLeadSpacing() {
        return this.leadSpacing;
    }

    public void setLeadSpacing(Size leadSpacing) {
        this.leadSpacing = leadSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Winding Spacing", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getWindingSpacing() {
        return this.windingSpacing;
    }

    public void setWindingSpacing(Size rowSpacing) {
        this.windingSpacing = rowSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.VALUE;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        int i;
        Point firstPoint = this.controlPoints[0];
        int pinCount = 4 + (this.primaryCT ? 1 : 0) + (this.secondaryCT ? 1 : 0);
        this.controlPoints = new Point[pinCount];
        this.controlPoints[0] = firstPoint;
        double leadSpacing = this.leadSpacing.convertToPixels();
        double windingSpacing = this.windingSpacing.convertToPixels();
        for (i = 1; i < 2 + (this.primaryCT ? 1 : 0); ++i) {
            this.controlPoints[i] = new Point(firstPoint.x, (int)((double)firstPoint.y + (double)i * leadSpacing * (double)(this.primaryCT ? 1 : 2)));
        }
        for (i = 0; i < 2 + (this.secondaryCT ? 1 : 0); ++i) {
            this.controlPoints[2 + (this.primaryCT ? 1 : 0) + i] = new Point((int)((double)firstPoint.x + windingSpacing), (int)((double)firstPoint.y + (double)i * leadSpacing * (double)(this.secondaryCT ? 1 : 2)));
        }
        AffineTransform tx = this.getTx();
        if (tx != null) {
            for (int i2 = 1; i2 < this.controlPoints.length; ++i2) {
                tx.transform(this.controlPoints[i2], this.controlPoints[i2]);
            }
        }
    }

    @Override
    public Area[] getBody() {
        if (this.body == null) {
            this.body = new Area[2];
            double leadSpacing = this.leadSpacing.convertToPixels();
            double windingSpacing = this.windingSpacing.convertToPixels();
            int centerX = (int)((double)this.controlPoints[0].x + windingSpacing / 2.0);
            int centerY = (int)((double)this.controlPoints[0].y + leadSpacing);
            int coreWidth = this.getClosestOdd(this.coreWidth.convertToPixels());
            int coreThickness = this.getClosestOdd(this.coreThickness.convertToPixels());
            int coilWidth = this.getClosestOdd(this.coilWidth.convertToPixels());
            int coilLength = this.getClosestOdd(this.coilLength.convertToPixels());
            this.body[0] = new Area(new Rectangle2D.Double(centerX - coreThickness / 2, centerY - coreWidth / 2, coreThickness, coreWidth));
            this.body[1] = new Area(new RoundRectangle2D.Double(centerX - coilLength / 2, centerY - coilWidth / 2, coilLength, coilWidth, coilWidth / 3, coilWidth / 3));
            this.body[1].subtract(this.body[0]);
            AffineTransform tx = this.getTx();
            if (tx != null) {
                for (Area b : this.body) {
                    if (b == null) continue;
                    b.transform(tx);
                }
            }
        }
        return this.body;
    }

    private AffineTransform getTx() {
        double x = this.controlPoints[0].x;
        double y = this.controlPoints[0].y;
        if (this.orientation == Orientation.DEFAULT) {
            return null;
        }
        double theta = 0.0;
        switch (this.orientation) {
            case _90: {
                theta = 1.5707963267948966;
                break;
            }
            case _180: {
                theta = Math.PI;
                break;
            }
            case _270: {
                theta = 4.71238898038469;
            }
        }
        AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
        return rotation;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area[] body = this.getBody();
        Area coreArea = body[0];
        Area coilArea = body[1];
        if (!outlineMode) {
            int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
            for (Point point : this.controlPoints) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
                g2d.setColor(PIN_BORDER_COLOR);
                g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
        }
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getCoilColor());
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.fill(coilArea);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = theme.getOutlineColor();
        } else {
            finalBorderColor = this.getCoilBorderColor();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(coilArea);
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getCoreColor());
        g2d.fill(coreArea);
        g2d.setComposite(oldComposite);
        if (!outlineMode) {
            finalBorderColor = this.getCoreBorderColor();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(coreArea);
        drawingObserver.stopTracking();
        g2d.setFont(project.getFont());
        Point wPoint = new Point(this.controlPoints[0].x + project.getFontSize(), (int)((double)this.controlPoints[0].y + this.leadSpacing.convertToPixels()));
        AffineTransform tx = this.getTx();
        if (tx != null) {
            tx.transform(wPoint, wPoint);
        }
        StringUtils.drawCenteredText(g2d, "P", wPoint.x, wPoint.y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        wPoint = new Point((int)((double)this.controlPoints[0].x + this.windingSpacing.convertToPixels() - (double)project.getFontSize()), (int)((double)this.controlPoints[0].y + this.leadSpacing.convertToPixels()));
        if (tx != null) {
            tx.transform(wPoint, wPoint);
        }
        StringUtils.drawCenteredText(g2d, "S", wPoint.x, wPoint.y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor();
        }
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        String[] label = null;
        if (this.getDisplay() == Display.NAME) {
            label = new String[]{this.getName()};
        } else if (this.getDisplay() == Display.VALUE) {
            label = new String[]{this.getValue().toString()};
        } else if (this.getDisplay() == Display.BOTH) {
            String[] stringArray;
            String value = this.getValue().toString();
            if (value.isEmpty()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.getName();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.getName();
                stringArray = stringArray3;
                stringArray3[1] = value;
            }
            label = stringArray;
        }
        if (label != null) {
            for (int i = 0; i < label.length; ++i) {
                String l = label[i];
                Rectangle2D rect = fontMetrics.getStringBounds(l, g2d);
                int textHeight = (int)rect.getHeight();
                int textWidth = (int)rect.getWidth();
                Rectangle bounds = coreArea.getBounds();
                int x = bounds.x + (bounds.width - textWidth) / 2;
                int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
                AffineTransform oldTransform = g2d.getTransform();
                if (this.getOrientation() == Orientation.DEFAULT || this.getOrientation() == Orientation._180) {
                    int centerX = bounds.x + bounds.width / 2;
                    int centerY = bounds.y + bounds.height / 2;
                    g2d.rotate(-1.5707963267948966, centerX, centerY);
                }
                if (label.length == 2) {
                    if (i == 0) {
                        g2d.translate(0, -textHeight / 2);
                    } else if (i == 1) {
                        g2d.translate(0, textHeight / 2);
                    }
                }
                g2d.drawString(l, x, y);
                g2d.setTransform(oldTransform);
            }
        }
        this.drawSelectionOutline(g2d, componentState, outlineMode, project, drawingObserver);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int radius = (int)(12.0f * (float)width / 32.0f);
        g2d.setColor(COIL_COLOR);
        g2d.fillRoundRect(1, (int)((float)height / 8.0f), width - 2, (int)((float)(height * 6) / 8.0f), radius, radius);
        g2d.setColor(COIL_BORDER_COLOR);
        g2d.drawRoundRect(1, (int)((float)height / 8.0f), width - 2, (int)((float)(height * 6) / 8.0f), radius, radius);
        g2d.setColor(CORE_COLOR);
        g2d.fillRect(width * 3 / 8, 1, width / 4, height - 2);
        g2d.setColor(CORE_BORDER_COLOR);
        g2d.drawRect(width * 3 / 8, 1, width / 4, height - 2);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        int pinSize = (int)(2.0f * (float)width / 32.0f);
        g2d.setColor(PIN_COLOR);
        for (int i = 0; i < 3; ++i) {
            g2d.fillOval(width / 5 - pinSize + 1, height / 6 * (i + 2), pinSize, pinSize);
            g2d.fillOval(4 * width / 5 + 1, height / 6 * (i + 2), pinSize, pinSize);
        }
    }

    @EditableProperty(name="Core")
    public Color getCoreColor() {
        if (this.coreColor == null) {
            this.coreColor = CORE_COLOR;
        }
        return this.coreColor;
    }

    public void setCoreColor(Color coreColor) {
        this.coreColor = coreColor;
    }

    @EditableProperty(name="Core Border")
    public Color getCoreBorderColor() {
        if (this.coreBorderColor == null) {
            this.coreBorderColor = CORE_BORDER_COLOR;
        }
        return this.coreBorderColor;
    }

    public void setCoreBorderColor(Color coreBorderColor) {
        this.coreBorderColor = coreBorderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty(name="Core Thickness")
    public Size getCoreThickness() {
        return this.coreThickness;
    }

    public void setCoreThickness(Size coreThickness) {
        this.coreThickness = coreThickness;
        this.body = null;
    }

    @EditableProperty(name="Core Width")
    public Size getCoreWidth() {
        return this.coreWidth;
    }

    public void setCoreWidth(Size coreWidth) {
        this.coreWidth = coreWidth;
        this.body = null;
    }

    @EditableProperty(name="Coil Width")
    public Size getCoilWidth() {
        return this.coilWidth;
    }

    public void setCoilWidth(Size coilWidth) {
        this.coilWidth = coilWidth;
        this.body = null;
    }

    @EditableProperty(name="Coil Length")
    public Size getCoilLength() {
        return this.coilLength;
    }

    public void setCoilLength(Size coilLength) {
        this.coilLength = coilLength;
        this.body = null;
    }

    @EditableProperty(name="Coil")
    public Color getCoilColor() {
        return this.coilColor;
    }

    public void setCoilColor(Color coilColor) {
        this.coilColor = coilColor;
    }

    @EditableProperty(name="Coil Border")
    public Color getCoilBorderColor() {
        return this.coilBorderColor;
    }

    public void setCoilBorderColor(Color coilBorderColor) {
        this.coilBorderColor = coilBorderColor;
    }

    @EditableProperty(name="Primary CT")
    public boolean getPrimaryCT() {
        return this.primaryCT;
    }

    public void setPrimaryCT(boolean primaryCT) {
        this.primaryCT = primaryCT;
        this.updateControlPoints();
    }

    @EditableProperty(name="Secondary CT")
    public boolean getSecondaryCT() {
        return this.secondaryCT;
    }

    public void setSecondaryCT(boolean secondaryCT) {
        this.secondaryCT = secondaryCT;
        this.updateControlPoints();
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

