/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.misc;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractComponent;
import org.diylc.components.transform.TextTransformer;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Label", author="Branislav Stojkovic", category="Misc", description="User defined label", instanceNamePrefix="L", zOrder=5.0, flexibleZOrder=true, bomPolicy=BomPolicy.NEVER_SHOW, transformer=TextTransformer.class)
public class Label
extends AbstractComponent<String> {
    public static String DEFAULT_TEXT = "Double click to edit text";
    private static final long serialVersionUID = 1L;
    private Point point = new Point(0, 0);
    private String text = DEFAULT_TEXT;
    private Font font = LABEL_FONT;
    private Color color = LABEL_COLOR;
    @Deprecated
    private boolean center;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private Orientation orientation = Orientation.DEFAULT;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setColor(componentState == ComponentState.SELECTED ? LABEL_COLOR_SELECTED : this.color);
        g2d.setFont(this.font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(this.text, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int x = this.point.x;
        int y = this.point.y;
        switch (this.getVerticalAlignment()) {
            case CENTER: {
                y = this.point.y - textHeight / 2 + fontMetrics.getAscent();
                break;
            }
            case TOP: {
                y = this.point.y - textHeight + fontMetrics.getAscent();
                break;
            }
            case BOTTOM: {
                y = this.point.y + fontMetrics.getAscent();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected alignment: " + this.getVerticalAlignment());
            }
        }
        switch (this.getHorizontalAlignment()) {
            case CENTER: {
                x = this.point.x - textWidth / 2;
                break;
            }
            case LEFT: {
                x = this.point.x;
                break;
            }
            case RIGHT: {
                x = this.point.x - textWidth;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected alignment: " + this.getHorizontalAlignment());
            }
        }
        switch (this.getOrientation()) {
            case _90: {
                g2d.rotate(1.5707963267948966, this.point.x, this.point.y);
                break;
            }
            case _180: {
                g2d.rotate(Math.PI, this.point.x, this.point.y);
                break;
            }
            case _270: {
                g2d.rotate(4.71238898038469, this.point.x, this.point.y);
            }
        }
        g2d.drawString(this.text, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(LABEL_COLOR);
        g2d.setFont(LABEL_FONT.deriveFont(13.0f * (float)width / 32.0f).deriveFont(0));
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds("Abc", g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int x = (width - textWidth) / 2 + 1;
        int y = (height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString("Abc", x, y);
    }

    @EditableProperty
    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @EditableProperty(name="Font Bold")
    public boolean getBold() {
        return this.font.isBold();
    }

    public void setBold(boolean bold) {
        this.font = bold ? (this.font.isItalic() ? this.font.deriveFont(3) : this.font.deriveFont(1)) : (this.font.isItalic() ? this.font.deriveFont(2) : this.font.deriveFont(0));
    }

    @EditableProperty(name="Font Italic")
    public boolean getItalic() {
        return this.font.isItalic();
    }

    public void setItalic(boolean italic) {
        this.font = italic ? (this.font.isBold() ? this.font.deriveFont(3) : this.font.deriveFont(2)) : (this.font.isBold() ? this.font.deriveFont(1) : this.font.deriveFont(0));
    }

    @EditableProperty
    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = Orientation.DEFAULT;
        }
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @EditableProperty(name="Font Size")
    public int getFontSize() {
        return this.font.getSize();
    }

    public void setFontSize(int size) {
        this.font = this.font.deriveFont((float)size);
    }

    public int getControlPointCount() {
        return 1;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Vertical Alignment")
    public VerticalAlignment getVerticalAlignment() {
        if (this.verticalAlignment == null) {
            this.verticalAlignment = VerticalAlignment.CENTER;
        }
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @EditableProperty(name="Horizontal Alignment")
    public HorizontalAlignment getHorizontalAlignment() {
        if (this.horizontalAlignment == null) {
            this.horizontalAlignment = HorizontalAlignment.CENTER;
        }
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        this.horizontalAlignment = alignment;
    }

    public String getName() {
        return super.getName();
    }

    @EditableProperty(name="Text", defaultable=false)
    public String getValue() {
        return this.text;
    }

    public void setValue(String value) {
        this.text = value;
    }

    public String getControlPointNodeName(int index) {
        return null;
    }
}

