/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.misc;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.diylc.components.AbstractSchematicLeadedSymbol;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.core.measures.Voltage;
import org.diylc.core.measures.VoltageUnit;

@ComponentDescriptor(name="Battery", author="N9XYP", category="Schematic Symbols", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="B", description="Battery schematic symbol", zOrder=4.0)
public class BatterySymbol
extends AbstractSchematicLeadedSymbol<String> {
    private static final long serialVersionUID = 1L;
    private String value = "Battery";
    public static Size DEFAULT_LENGTH = new Size(Double.valueOf(0.05), SizeUnit.in);
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.15), SizeUnit.in);
    private Voltage voltageNew = new Voltage(Double.valueOf(9.0), VoltageUnit.V);

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getVoltageNew() == null ? "" : " " + this.getVoltageNew().toString());
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty(name="Voltage")
    public Voltage getVoltageNew() {
        return this.voltageNew;
    }

    public void setVoltageNew(Voltage voltageNew) {
        this.voltageNew = voltageNew;
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_LENGTH;
    }

    @Override
    protected Shape getBodyShape() {
        GeneralPath polyline = new GeneralPath();
        double length = this.getLength().convertToPixels();
        double width = this.getWidth().convertToPixels();
        polyline.moveTo(0.0f, 0.0f);
        polyline.lineTo(0.0, width);
        polyline.moveTo(length, width / 4.0);
        polyline.lineTo(length, width - width / 4.0);
        return polyline;
    }

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        g2d.setColor(this.getBorderColor());
        int plusSize = this.getClosestOdd(this.getWidth().convertToPixels() / 4.0);
        int x = -plusSize;
        int y = plusSize;
        g2d.drawLine(x - plusSize / 2, y - plusSize, x + plusSize / 2, y - plusSize);
        g2d.drawLine(x, y - plusSize / 2, x, y - plusSize * 3 / 2);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(COLOR);
        g2d.drawLine(0, height / 2, 13 * width / 32, height / 2);
        g2d.drawLine(width - 13 * width / 32, height / 2, width, height / 2);
        g2d.setColor(COLOR);
        g2d.drawLine(14 * width / 32, height / 2 - 6 * width / 32, 14 * width / 32, height / 2 + 6 * width / 32);
        g2d.drawLine(width - 14 * width / 32, height / 2 - 3, width - 14 * width / 32, height / 2 + 3 * width / 32);
        g2d.drawLine(height / 2 - 4 * width / 32, height / 2 - 5 * width / 32, height / 2 - 8 * width / 32, height / 2 - 5 * width / 32);
        g2d.drawLine(height / 2 - 6 * width / 32, height / 2 - 3 * width / 32, height / 2 - 6 * width / 32, height / 2 - 7 * width / 32);
    }

    @Override
    public String getControlPointNodeName(int index) {
        return this.getName() + "." + (index == 0 ? "+" : "-");
    }
}

