/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.misc;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.BomEntry;
import org.diylc.utils.BomMaker;

@ComponentDescriptor(name="Bill of Materials", author="Branislav Stojkovic", category="Misc", description="", instanceNamePrefix="BOM", zOrder=5.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class BOM
extends AbstractComponent<Void> {
    public static Size DEFAULT_SIZE = new Size(Double.valueOf(10.0), SizeUnit.cm);
    public static Size SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Color COLOR = Color.black;
    public static String DEFAULT_TEXT = "No components to show in the Bill of Materials";
    private static final long serialVersionUID = 1L;
    private Size size = DEFAULT_SIZE;
    private Point point = new Point(0, 0);
    private Color color = COLOR;

    public String getControlPointNodeName(int index) {
        return null;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        List bom = BomMaker.getInstance().createBom(project.getComponents());
        Iterator iterator = bom.iterator();
        while (iterator.hasNext()) {
            BomEntry entry = (BomEntry)iterator.next();
            if (entry.getValue() != null && !entry.getName().toLowerCase().contains("bom")) continue;
            iterator.remove();
        }
        g2d.setFont(project.getFont());
        g2d.setColor(componentState == ComponentState.DRAGGING || componentState == ComponentState.SELECTED ? SELECTION_COLOR : this.getColor());
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int maxNameWidth = 0;
        int maxValueWidth = 0;
        int maxHeight = 0;
        for (BomEntry entry : bom) {
            String valueStr = entry.getValue() == null || entry.getValue().trim().isEmpty() ? "qty " + entry.getQuantity().toString() : entry.getValue().toString();
            Rectangle2D stringBounds = fontMetrics.getStringBounds(entry.getName(), g2d);
            if (stringBounds.getWidth() > (double)maxNameWidth) {
                maxNameWidth = (int)stringBounds.getWidth();
            }
            if (stringBounds.getHeight() > (double)maxHeight) {
                maxHeight = (int)stringBounds.getHeight();
            }
            if ((stringBounds = fontMetrics.getStringBounds(valueStr, g2d)).getWidth() > (double)maxValueWidth) {
                maxValueWidth = (int)stringBounds.getWidth();
            }
            if (!(stringBounds.getHeight() > (double)maxHeight)) continue;
            maxHeight = (int)stringBounds.getHeight();
        }
        int maxEntrySize = maxNameWidth + maxValueWidth + 2 * (int)SPACING.convertToPixels();
        int columnCount = (int)this.size.convertToPixels() / maxEntrySize;
        if (columnCount == 0) {
            columnCount = 1;
        }
        int columnWidth = (int)this.size.convertToPixels() / columnCount;
        int entriesPerColumn = (int)Math.ceil(1.0 * (double)bom.size() / (double)columnCount);
        if (entriesPerColumn == 0) {
            g2d.drawString(DEFAULT_TEXT, this.point.x, this.point.y);
            return;
        }
        for (int i = 0; i < bom.size(); ++i) {
            BomEntry entry = (BomEntry)bom.get(i);
            String valueStr = entry.getValue() == null || entry.getValue().trim().isEmpty() ? "qty " + entry.getQuantity().toString() : entry.getValue().toString();
            int columnIndex = i / entriesPerColumn;
            int rowIndex = i % entriesPerColumn;
            int x = this.point.x + columnIndex * columnWidth;
            int y = this.point.y + rowIndex * maxHeight;
            g2d.drawString(entry.getName(), x, y);
            x = (int)((double)x + ((double)maxNameWidth + SPACING.convertToPixels()));
            g2d.drawString(valueStr, x, y);
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(Color.white);
        g2d.fillRect(width / 8, 0, 6 * width / 8, height - 1);
        g2d.setColor(Color.black);
        g2d.drawRect(width / 8, 0, 6 * width / 8, height - 1);
        g2d.setFont(LABEL_FONT.deriveFont(9.0f * (float)width / 32.0f).deriveFont(0));
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds("BOM", g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int x = (width - textWidth) / 2 + 1;
        int y = textHeight + 2;
        g2d.drawString("BOM", x, y);
        g2d.setFont(g2d.getFont().deriveFont(5.0f * (float)width / 32.0f));
        fontMetrics = g2d.getFontMetrics();
        rect = fontMetrics.getStringBounds("resistors", g2d);
        x = (width - textWidth) / 2 + 1;
        y = height / 2 + 2;
        g2d.drawString("resistors", x, y);
        y = (int)((double)y + (rect.getHeight() - 1.0));
        g2d.drawString("tubes", x, y);
        y = (int)((double)y + (rect.getHeight() - 1.0));
        g2d.drawString("diodes", x, y);
    }

    public int getControlPointCount() {
        return 1;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty(name="Width")
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @EditableProperty
    public Color getColor() {
        if (this.color == null) {
            this.color = COLOR;
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }
}

