/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.OrientationHV;
import org.diylc.components.RoundedPath;
import org.diylc.components.guitar.AbstractGuitarPickup;
import org.diylc.components.guitar.AbstractSingleOrHumbuckerPickup;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Single Coil Pickup", category="Guitar", author="Branislav Stojkovic", description="Single coil guitar pickup, both Strat and Tele style", zOrder=4.0, instanceNamePrefix="PKP", autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Guitar Wiring Diagram")
public class SingleCoilPickup
extends AbstractSingleOrHumbuckerPickup {
    private static final long serialVersionUID = 1L;
    private static Color BODY_COLOR = Color.white;
    private static Color BASE_COLOR = Color.gray;
    public static Color LUG_COLOR = Color.decode("#E0C04C");
    private static Size WIDTH = new Size(Double.valueOf(15.5), SizeUnit.mm);
    private static Size LENGTH = new Size(Double.valueOf(83.0), SizeUnit.mm);
    private static Size BASE_RADIUS = new Size(Double.valueOf(0.15), SizeUnit.in);
    private static Size LUG_DIAMETER = new Size(Double.valueOf(0.06), SizeUnit.in);
    private static Size STRAT_LIP_WIDTH = new Size(Double.valueOf(5.0), SizeUnit.mm);
    private static Size STRAT_LIP_LENGTH = new Size(Double.valueOf(20.0), SizeUnit.mm);
    private static Size STRAT_INNER_LENGTH = new Size(Double.valueOf(70.0), SizeUnit.mm);
    private static Size TELE_BASE_WIDTH = new Size(Double.valueOf(1.5), SizeUnit.in);
    private static Size TELE_LIP_LENGTH = new Size(Double.valueOf(1.735), SizeUnit.in);
    private static Size TELE_LENGTH = new Size(Double.valueOf(2.87), SizeUnit.in);
    private static Size TELE_HOLE_SPACING = new Size(Double.valueOf(1.135), SizeUnit.in);
    private static Size HOLE_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private static Size HOLE_MARGIN = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size POLE_SIZE = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size POLE_SPACING = new Size(Double.valueOf(11.68), SizeUnit.mm);
    private static Size RAIL_WIDTH = new Size(Double.valueOf(1.5), SizeUnit.mm);
    private static Size RAIL_LENGTH = new Size(Double.valueOf(60.0), SizeUnit.mm);
    private static Size COIL_SPACING = new Size(Double.valueOf(7.5), SizeUnit.mm);
    private Color color = BODY_COLOR;
    private Color poleColor = METAL_COLOR;
    private Color baseColor = BASE_COLOR;
    private SingleCoilType type = SingleCoilType.Stratocaster;
    private PolePieceType polePieceType = PolePieceType.Rods;
    private Color lugColor = LUG_COLOR;

    @Override
    protected OrientationHV getControlPointDirection() {
        return OrientationHV.HORIZONTAL;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBaseColor());
        g2d.fill(body[4]);
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getColor());
        if (body[3] == null) {
            g2d.fill(body[0]);
        } else {
            g2d.fill(body[3]);
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getLugColor());
        g2d.fill(body[1]);
        g2d.setColor(outlineMode ? theme.getOutlineColor() : this.darkerOrLighter(LUG_COLOR));
        g2d.draw(body[1]);
        g2d.setComposite(oldComposite);
        Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.darkerOrLighter(this.getBaseColor()));
        g2d.setColor(finalBorderColor);
        g2d.draw(body[4]);
        finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.darkerOrLighter(this.color));
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        if (body[3] != null) {
            g2d.draw(body[3]);
        }
        if (!outlineMode) {
            g2d.setColor(this.getPoleColor());
            g2d.fill(body[2]);
            g2d.setColor(this.darkerOrLighter(this.getPoleColor()));
            g2d.draw(body[2]);
        }
        this.drawMainLabel(g2d, project, outlineMode, componentState);
        this.drawlTerminalLabels(g2d, finalBorderColor, project);
    }

    @Override
    protected int getMainLabelYOffset() {
        if (this.getPolePieceType() == PolePieceType.RailHumbucker || this.getPolePieceType() == PolePieceType.RodHumbucker || this.getPolePieceType() == PolePieceType.None) {
            return 0;
        }
        return (int)(WIDTH.convertToPixels() / 2.0 - 20.0);
    }

    @Override
    public Shape[] getBody() {
        if (this.body == null) {
            int poleMargin;
            this.body = new Shape[5];
            Point[] points = this.getControlPoints();
            int x = (points[0].x + points[3].x) / 2;
            int y = (points[0].y + points[3].y) / 2;
            int width = (int)WIDTH.convertToPixels();
            int length = (int)LENGTH.convertToPixels();
            int stratInnerLength = (int)STRAT_INNER_LENGTH.convertToPixels();
            int teleLength = (int)TELE_LENGTH.convertToPixels();
            int teleBaseWidth = (int)TELE_BASE_WIDTH.convertToPixels();
            int teleLipLength = this.getClosestOdd(TELE_LIP_LENGTH.convertToPixels());
            int teleHoleSpacing = (int)TELE_HOLE_SPACING.convertToPixels();
            int coilLength = this.getType() == SingleCoilType.Stratocaster ? stratInnerLength : teleLength;
            int lipWidth = (int)STRAT_LIP_WIDTH.convertToPixels();
            int lipLength = (int)STRAT_LIP_LENGTH.convertToPixels();
            int lugDiameter = this.getClosestOdd(LUG_DIAMETER.convertToPixels());
            int holeSize = this.getClosestOdd(HOLE_SIZE.convertToPixels());
            int holeMargin = this.getClosestOdd(HOLE_MARGIN.convertToPixels());
            int baseRadius = (int)BASE_RADIUS.convertToPixels();
            int coilOffset = 0;
            if (this.getType() == SingleCoilType.Stratocaster) {
                coilOffset = lipWidth / 2;
                Area mainArea = new Area(new RoundRectangle2D.Double(x - length / 2, y - lipWidth / 2 - width, length, width, width, width));
                mainArea.subtract(new Area(new Ellipse2D.Double(x - length / 2 + holeMargin - holeSize / 2, y - lipWidth / 2 - width / 2 - holeSize / 2, holeSize, holeSize)));
                mainArea.subtract(new Area(new Ellipse2D.Double(x + length / 2 - holeMargin - holeSize / 2, y - lipWidth / 2 - width / 2 - holeSize / 2, holeSize, holeSize)));
                this.body[3] = mainArea;
                RoundedPath basePath = new RoundedPath(baseRadius);
                basePath.moveTo(x, y + lipWidth / 2);
                basePath.lineTo(x + lipLength / 2, y + lipWidth / 2);
                basePath.lineTo(x + length / 2, y - lipWidth);
                basePath.lineTo(x - length / 2, y - lipWidth);
                basePath.lineTo(x - lipLength / 2, y + lipWidth / 2);
                basePath.lineTo(x, y + lipWidth / 2);
                Area base = new Area(basePath.getPath());
                base.subtract(mainArea);
                this.body[4] = base;
            } else if (this.getType() == SingleCoilType.Telecaster) {
                coilOffset = (teleBaseWidth - width) / 4;
                RoundedPath basePath = new RoundedPath(baseRadius);
                basePath.moveTo(x, y + coilOffset);
                basePath.lineTo(x + teleLipLength / 2, y + coilOffset);
                basePath.lineTo((double)x + (double)coilLength * 0.53, y - coilOffset - width / 2);
                basePath.lineTo((double)(x + coilLength / 2) - (double)width * 0.45, y - coilOffset - width);
                basePath.lineTo(x, y - 3 * coilOffset - width);
                basePath.lineTo((double)(x - coilLength / 2) + (double)width * 0.45, y - coilOffset - width);
                basePath.lineTo((double)x - (double)coilLength * 0.53, y - coilOffset - width / 2);
                basePath.lineTo(x - teleLipLength / 2, y + coilOffset);
                basePath.lineTo(x, y + coilOffset);
                Area base = new Area(basePath.getPath());
                base.intersect(new Area(new Rectangle2D.Double((double)x - (double)coilLength * 0.48, y - teleBaseWidth, (double)coilLength * 0.96, teleBaseWidth * 2)));
                base.subtract(new Area(new Ellipse2D.Double(x - teleLipLength / 2 - holeSize / 2, y, holeSize, holeSize)));
                base.subtract(new Area(new Ellipse2D.Double(x + teleLipLength / 2 - holeSize / 2, y, holeSize, holeSize)));
                base.subtract(new Area(new Ellipse2D.Double(x - holeSize / 2, y - teleHoleSpacing, holeSize, holeSize)));
                this.body[4] = base;
            }
            Area poleArea = new Area();
            if (this.getPolePieceType() == PolePieceType.Rods) {
                int poleSize = (int)POLE_SIZE.convertToPixels();
                int poleSpacing = (int)POLE_SPACING.convertToPixels();
                poleMargin = (length - poleSpacing * 5) / 2;
                for (int i = 0; i < 6; ++i) {
                    Ellipse2D.Double pole = new Ellipse2D.Double(x - length / 2 + poleMargin + i * poleSpacing - poleSize / 2, y - coilOffset - width / 2 - poleSize / 2, poleSize, poleSize);
                    poleArea.add(new Area(pole));
                }
            } else if (this.getPolePieceType() == PolePieceType.RodHumbucker) {
                int poleSize = (int)POLE_SIZE.convertToPixels() / 2;
                int poleSpacing = (int)POLE_SPACING.convertToPixels();
                poleMargin = (length - poleSpacing * 5) / 2;
                int coilSpacing = (int)COIL_SPACING.convertToPixels();
                for (int i = 0; i < 6; ++i) {
                    poleArea.add(new Area(new Ellipse2D.Double(x - length / 2 + poleMargin + i * poleSpacing - poleSize / 2, y - coilOffset - width / 2 - poleSize / 2 - coilSpacing / 2, poleSize, poleSize)));
                    poleArea.add(new Area(new Ellipse2D.Double(x - length / 2 + poleMargin + i * poleSpacing - poleSize / 2, y - coilOffset - width / 2 - poleSize / 2 + coilSpacing / 2, poleSize, poleSize)));
                }
            } else if (this.getPolePieceType() == PolePieceType.RailHumbucker) {
                int railWidth = (int)RAIL_WIDTH.convertToPixels();
                int railSpacing = (int)COIL_SPACING.convertToPixels();
                int railLength = (int)RAIL_LENGTH.convertToPixels();
                poleArea.add(new Area(new Rectangle2D.Double(x - railLength / 2, y - coilOffset - width / 2 - railSpacing / 2 - railWidth / 2, railLength, railWidth)));
                poleArea.add(new Area(new Rectangle2D.Double(x - railLength / 2, y - coilOffset - width / 2 + railSpacing / 2 - railWidth / 2, railLength, railWidth)));
            } else if (this.getPolePieceType() == PolePieceType.Rail) {
                int railWidth = 2 * (int)RAIL_WIDTH.convertToPixels();
                int railLength = (int)RAIL_LENGTH.convertToPixels();
                poleArea.add(new Area(new RoundRectangle2D.Double(x - railLength / 2, y - coilOffset - width / 2 - railWidth / 2, railLength, railWidth, railWidth / 2, railWidth / 2)));
            }
            this.body[0] = new Area(new RoundRectangle2D.Double(x - coilLength / 2, y - coilOffset - width, coilLength, width, width, width));
            this.body[2] = poleArea;
            if (this.body[3] == null) {
                ((Area)this.body[4]).subtract((Area)this.body[0]);
            }
            if (this.orientation != Orientation.DEFAULT) {
                double theta = 0.0;
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
                for (Shape shape : this.body) {
                    Area area = (Area)shape;
                    if (area == null) continue;
                    area.transform(rotation);
                }
            }
            this.body[1] = new Area();
            double lugHole = this.getClosestOdd((double)lugDiameter * 0.4);
            for (int i = this.getPolarity() == AbstractGuitarPickup.Polarity.Humbucking ? 0 : 1; i < (this.getPolarity() == AbstractGuitarPickup.Polarity.Humbucking ? 4 : 3); ++i) {
                Point p = points[i];
                ((Area)this.body[1]).add(new Area(new Ellipse2D.Double(p.x - lugDiameter / 2, p.y - lugDiameter / 2, lugDiameter, lugDiameter)));
                ((Area)this.body[1]).subtract(new Area(new Ellipse2D.Double((double)p.x - lugHole / 2.0, (double)p.y - lugHole / 2.0, lugHole, lugHole)));
            }
        }
        return this.body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(0.7853981633974483, width / 2, height / 2);
        int bodyWidth = 8 * width / 32;
        int bodyLength = 30 * width / 32;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(BASE_COLOR);
        g2d.fillPolygon(new int[]{width * 9 / 16, width * 9 / 16, width * 11 / 16, width * 11 / 16}, new int[]{(height - bodyLength) / 2, (height + bodyLength) / 2, height * 5 / 8, height * 3 / 8}, 4);
        g2d.setColor(BODY_COLOR);
        g2d.fillRoundRect((width - bodyWidth) / 2, (height - bodyLength) / 2, bodyWidth, bodyLength, bodyWidth, bodyWidth);
        g2d.setColor(Color.gray);
        g2d.drawRoundRect((width - bodyWidth) / 2, (height - bodyLength) / 2, bodyWidth, bodyLength, bodyWidth, bodyWidth);
        g2d.setColor(METAL_COLOR);
        int poleSize = 2;
        int poleSpacing = 17 * width / 32;
        for (int i = 0; i < 6; ++i) {
            g2d.fillOval((width - poleSize) / 2, (height - poleSpacing) / 2 + i * poleSpacing / 5, poleSize, poleSize);
        }
    }

    @EditableProperty
    public SingleCoilType getType() {
        if (this.type == null) {
            this.type = SingleCoilType.Stratocaster;
        }
        return this.type;
    }

    public void setType(SingleCoilType type) {
        this.type = type;
        this.body = null;
    }

    @EditableProperty(name="Pole Pieces")
    public PolePieceType getPolePieceType() {
        if (this.polePieceType == null) {
            this.polePieceType = PolePieceType.Rods;
        }
        return this.polePieceType;
    }

    public void setPolePieceType(PolePieceType polePieceType) {
        this.polePieceType = polePieceType;
        this.body = null;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Base")
    public Color getBaseColor() {
        if (this.baseColor == null) {
            this.baseColor = BASE_COLOR;
        }
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor;
    }

    @EditableProperty(name="Pole Color")
    public Color getPoleColor() {
        if (this.poleColor == null) {
            this.poleColor = METAL_COLOR;
        }
        return this.poleColor;
    }

    public void setPoleColor(Color poleColor) {
        this.poleColor = poleColor;
    }

    @EditableProperty(name="Lugs")
    public Color getLugColor() {
        if (this.lugColor == null) {
            this.lugColor = LUG_COLOR;
        }
        return this.lugColor;
    }

    public void setLugColor(Color lugColor) {
        this.lugColor = lugColor;
    }

    public static enum PolePieceType {
        Rods("Single Rods"),
        Rail("Single Rail"),
        RailHumbucker("Dual Rail Humbucker"),
        RodHumbucker("Dual Rods"),
        None("None");

        private String label;

        private PolePieceType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum SingleCoilType {
        Stratocaster,
        Telecaster;

    }
}

