/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.ISwitch;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Lever Switch", category="Guitar", author="Branislav Stojkovic", description="Strat-style lever switch", zOrder=4.0, instanceNamePrefix="SW", keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Guitar Wiring Diagram")
public class LeverSwitch
extends AbstractTransparentComponent<String>
implements ISwitch {
    private static final long serialVersionUID = 1L;
    private static Color BASE_COLOR = Color.lightGray;
    private static Color WAFER_COLOR = Color.decode("#CD8500");
    private static Color LUG_COLOR = METAL_COLOR;
    private static Color COMMON_LUG_COLOR = Color.decode("#FF9999");
    private static Size BASE_WIDTH = new Size(Double.valueOf(10.0), SizeUnit.mm);
    private static Size BASE_LENGTH = new Size(Double.valueOf(47.5), SizeUnit.mm);
    private static Size WAFER_LENGTH = new Size(Double.valueOf(40.0), SizeUnit.mm);
    private static Size WAFER_SPACING = new Size(Double.valueOf(7.62), SizeUnit.mm);
    private static Size WAFER_THICKNESS = new Size(Double.valueOf(1.27), SizeUnit.mm);
    private static Size HOLE_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private static Size HOLE_SPACING = new Size(Double.valueOf(41.2), SizeUnit.mm);
    private static Size TERMINAL_WIDTH = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private static Size TERMINAL_LENGTH = new Size(Double.valueOf(0.1), SizeUnit.in);
    private static Size TERMINAL_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    private String value = "";
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    transient Shape[] body;
    private Orientation orientation = Orientation.DEFAULT;
    private LeverSwitchType type = LeverSwitchType.DP3T;
    private Boolean highlightCommon;

    public LeverSwitch() {
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Theme theme;
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BASE_COLOR);
            g2d.fill(body[0]);
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : WAFER_COLOR);
            g2d.fill(body[1]);
            g2d.setComposite(oldComposite);
        }
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BASE_COLOR.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : WAFER_COLOR.darker();
        }
        g2d.draw(body[1]);
        g2d.setColor(LUG_COLOR);
        g2d.fill(body[2]);
        g2d.setColor(LUG_COLOR.darker());
        g2d.draw(body[2]);
        g2d.setColor(COMMON_LUG_COLOR);
        g2d.fill(body[3]);
        g2d.setColor(COMMON_LUG_COLOR.darker());
        g2d.draw(body[3]);
    }

    public Shape[] getBody() {
        if (this.body == null) {
            int yOffset;
            this.body = new Shape[4];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int baseWidth = (int)BASE_WIDTH.convertToPixels();
            int baseLength = (int)BASE_LENGTH.convertToPixels();
            int holeSize = this.getClosestOdd(HOLE_SIZE.convertToPixels());
            int holeSpacing = (int)HOLE_SPACING.convertToPixels();
            int waferLength = (int)WAFER_LENGTH.convertToPixels();
            int waferSpacing = (int)WAFER_SPACING.convertToPixels();
            int waferThickness = (int)WAFER_THICKNESS.convertToPixels();
            int terminalSpacing = (int)TERMINAL_SPACING.convertToPixels();
            int terminalLength = this.getClosestOdd(TERMINAL_LENGTH.convertToPixels());
            int terminalWidth = this.getClosestOdd(TERMINAL_WIDTH.convertToPixels());
            if (this.type == LeverSwitchType.DP3T || this.type == LeverSwitchType.DP4T || this.type == LeverSwitchType.DP3T_5pos) {
                x += terminalLength;
                yOffset = 7;
            } else {
                yOffset = 12;
            }
            int baseX = x - terminalLength / 2 - waferSpacing;
            int baseY = y - (baseLength - terminalSpacing * yOffset) / 2;
            Area baseArea = new Area(new Rectangle2D.Double(baseX, baseY, baseWidth, baseLength));
            baseArea.subtract(new Area(new Ellipse2D.Double(baseX + baseWidth / 2 - holeSize / 2, baseY + (baseLength - holeSpacing) / 2 - holeSize / 2, holeSize, holeSize)));
            baseArea.subtract(new Area(new Ellipse2D.Double(baseX + baseWidth / 2 - holeSize / 2, baseY + (baseLength - holeSpacing) / 2 - holeSize / 2 + holeSpacing, holeSize, holeSize)));
            this.body[0] = baseArea;
            Area waferArea = new Area(new Rectangle2D.Double(x - terminalLength / 2 - waferThickness / 2, y - (waferLength - terminalSpacing * yOffset) / 2, waferThickness, waferLength));
            if (this.type == LeverSwitchType._4P5T) {
                waferArea.add(new Area(new Rectangle2D.Double(x - terminalLength / 2 - waferThickness / 2 + waferSpacing, y - (waferLength - terminalSpacing * 12) / 2, waferThickness, waferLength)));
            }
            this.body[1] = waferArea;
            double theta = 0.0;
            if (this.orientation != Orientation.DEFAULT) {
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
            }
            Area terminalArea = new Area();
            Area commonTerminalArea = new Area();
            for (int i = 0; i < this.controlPoints.length; ++i) {
                Point point = this.controlPoints[i];
                Area terminal = new Area(new RoundRectangle2D.Double(point.x - terminalLength / 2, point.y - terminalWidth / 2, terminalLength, terminalWidth, terminalWidth / 2, terminalWidth / 2));
                terminal.subtract(new Area(new RoundRectangle2D.Double(point.x - terminalLength / 4, point.y - terminalWidth / 4, terminalLength / 2, terminalWidth / 2, terminalWidth / 2, terminalWidth / 2)));
                if (theta != 0.0) {
                    AffineTransform rotation = AffineTransform.getRotateInstance(theta, point.x, point.y);
                    terminal.transform(rotation);
                }
                terminalArea.add(terminal);
                if (!(!this.getHighlightCommon().booleanValue() || (this.type != LeverSwitchType.DP3T && this.type != LeverSwitchType.DP3T_5pos || i != 1 && i != 6) && (this.type != LeverSwitchType.DP4T || i != 1 && i != 8) && (this.type != LeverSwitchType._4P5T && this.type != LeverSwitchType.DP5T || i != 0 && i != 11 && i != 12 && i != 23))) {
                    commonTerminalArea.add(terminal);
                    continue;
                }
                terminalArea.add(terminal);
            }
            this.body[2] = terminalArea;
            this.body[3] = commonTerminalArea;
            if (theta != 0.0) {
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, this.controlPoints[0].x, this.controlPoints[0].y);
                for (int i = 0; i < this.body.length - 2; ++i) {
                    Shape shape = this.body[i];
                    Area area = (Area)shape;
                    area.transform(rotation);
                }
            }
        }
        return this.body;
    }

    private void updateControlPoints() {
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        int waferSpacing = (int)WAFER_SPACING.convertToPixels();
        int terminalSpacing = (int)TERMINAL_SPACING.convertToPixels();
        int terminalLength = (int)TERMINAL_LENGTH.convertToPixels();
        switch (this.type) {
            case DP3T: 
            case DP3T_5pos: {
                int i;
                this.controlPoints = new Point[8];
                for (i = 0; i < 8; ++i) {
                    this.controlPoints[i] = new Point(x + (i % 2 == 1 ? terminalLength : 0), y + i * terminalSpacing);
                }
                break;
            }
            case DP4T: {
                int i;
                this.controlPoints = new Point[10];
                for (i = 0; i < 10; ++i) {
                    this.controlPoints[i] = new Point(x + (i % 2 == 1 ? terminalLength : 0), y + i * terminalSpacing);
                }
                break;
            }
            case DP5T: {
                int i;
                this.controlPoints = new Point[12];
                for (i = 0; i < 12; ++i) {
                    this.controlPoints[i] = new Point(x, y + i * terminalSpacing + (i >= 6 ? terminalSpacing : 0));
                }
                break;
            }
            case _4P5T: {
                int i;
                this.controlPoints = new Point[24];
                for (i = 0; i < 12; ++i) {
                    this.controlPoints[i] = new Point(x, y + i * terminalSpacing + (i >= 6 ? terminalSpacing : 0));
                    this.controlPoints[i + 12] = new Point(x + waferSpacing, y + i * terminalSpacing + (i >= 6 ? terminalSpacing : 0));
                }
                break;
            }
        }
        if (this.orientation != Orientation.DEFAULT) {
            double theta = 0.0;
            switch (this.orientation) {
                case _90: {
                    theta = 1.5707963267948966;
                    break;
                }
                case _180: {
                    theta = Math.PI;
                    break;
                }
                case _270: {
                    theta = 4.71238898038469;
                }
            }
            AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
            for (Point point : this.controlPoints) {
                rotation.transform(point, point);
            }
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setClip(width / 32, width / 32, width, height);
        g2d.setColor(BASE_COLOR);
        g2d.fillRect(0, 0, width * 2 / 3, height);
        g2d.setColor(BASE_COLOR.darker());
        g2d.drawRect(0, 0, width * 2 / 3, height);
        g2d.setColor(WAFER_COLOR);
        g2d.fillRect(width / 8 * 3, 0, width / 8, height);
        g2d.setColor(WAFER_COLOR.darker());
        g2d.drawRect(width / 8 * 3, 0, width / 8, height);
        Area terminals = new Area();
        int terminalLength = this.getClosestOdd(11 * width / 32);
        int terminalWidth = this.getClosestOdd(7 * width / 32);
        Area terminal = new Area(new RoundRectangle2D.Double(width / 16 * 7, 4 * width / 32, terminalLength, terminalWidth, terminalWidth / 2, terminalWidth / 2));
        terminal.subtract(new Area(new RoundRectangle2D.Double(width / 16 * 7 + terminalLength / 4 + 1, 4 * width / 32 + terminalWidth / 4 + 1, terminalLength / 2, terminalWidth / 2, terminalWidth / 4, terminalWidth / 4)));
        terminals.add(terminal);
        terminal = new Area(terminal);
        terminal.transform(AffineTransform.getTranslateInstance(-terminalLength, terminalWidth + 2 * width / 32));
        terminals.add(terminal);
        terminal = new Area(terminal);
        terminal.transform(AffineTransform.getTranslateInstance(terminalLength, terminalWidth + 2 * width / 32));
        terminals.add(terminal);
        g2d.setColor(METAL_COLOR);
        g2d.fill(terminals);
        g2d.setColor(METAL_COLOR.darker());
        g2d.draw(terminals);
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    @EditableProperty
    public LeverSwitchType getType() {
        return this.type;
    }

    public void setType(LeverSwitchType type) {
        this.type = type;
        this.updateControlPoints();
        this.body = null;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Mark Common Lugs")
    public Boolean getHighlightCommon() {
        if (this.highlightCommon == null) {
            this.highlightCommon = true;
        }
        return this.highlightCommon;
    }

    public void setHighlightCommon(Boolean highlightCommon) {
        this.highlightCommon = highlightCommon;
        this.body = null;
    }

    public int getPositionCount() {
        switch (this.type) {
            case DP3T: {
                return 3;
            }
            case DP4T: {
                return 4;
            }
            case DP3T_5pos: 
            case DP5T: 
            case _4P5T: {
                return 5;
            }
        }
        return 0;
    }

    public String getPositionName(int position) {
        return Integer.toString(position + 1);
    }

    public boolean arePointsConnected(int index1, int index2, int position) {
        switch (this.type) {
            case DP3T: {
                return index1 == 1 && index2 == index1 + 2 * (position + 1) || index2 == 6 && index2 == index1 + 2 * (3 - position);
            }
            case DP4T: {
                return index1 == 1 && index2 == index1 + 2 * (position + 1) || index2 == 8 && index2 == index1 + 2 * (4 - position);
            }
            case DP3T_5pos: {
                if (position % 2 == 0) {
                    return index1 == 1 && index2 == index1 + position + 2 || index2 == 6 && index2 == index1 + 6 - position;
                }
                return index2 == 6 && (index1 == 2 || index1 == 0 && position == 1 || index1 == 4 && position == 3) || index1 == 1 && (index2 == 5 || index2 == 3 && position == 1 || index2 == 7 && position == 3);
            }
            case DP5T: {
                return (index1 == 0 || index2 == 11) && index2 - index1 == position + 1;
            }
            case _4P5T: {
                return (index1 == 0 || index1 == 12 || index2 == 11 || index2 == 23) && index2 - index1 == position + 1;
            }
        }
        return false;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public static enum LeverSwitchType {
        DP3T("DP3T (Standard 3-Position Strat)"),
        DP3T_5pos("DP3T (Standard 5-Position Strat)"),
        _4P5T("4P5T (Super/Mega)"),
        DP4T("DP4T (4-Position Tele)"),
        DP5T("DP5T");

        private String title;

        private LeverSwitchType(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

