/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.transform.DIL_ICTransformer;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.ISwitch;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="DIP Switch", author="Branislav Stojkovic", category="Electro-Mechanical", instanceNamePrefix="SW", description="Dual-in-line package switch", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE, transformer=DIL_ICTransformer.class)
public class DIPSwitch
extends AbstractTransparentComponent<String>
implements ISwitch {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.decode("#E84E46");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color TICK_COLOR = Color.white;
    public static Color LABEL_COLOR = Color.white;
    public static int EDGE_RADIUS = 2;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.04), SizeUnit.in);
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.4), SizeUnit.in);
    public static Size INDENT_SIZE = new Size(Double.valueOf(0.07), SizeUnit.in);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private SwitchCount switchCount = SwitchCount._8;
    private Size pinSpacing = new Size(Double.valueOf(0.1), SizeUnit.in);
    private Size rowSpacing = new Size(Double.valueOf(0.3), SizeUnit.in);
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    protected Display display = Display.NONE;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;
    private Color tickColor = TICK_COLOR;
    private Size width = DEFAULT_WIDTH;
    private transient Area[] body;

    public DIPSwitch() {
        this.updateControlPoints();
        this.alpha = (byte)100;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Switches")
    public SwitchCount getSwitchCount() {
        return this.switchCount;
    }

    public void setSwitchCount(SwitchCount switchCount) {
        this.switchCount = switchCount;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Pin Spacing", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getPinSpacing() {
        return this.pinSpacing;
    }

    public void setPinSpacing(Size pinSpacing) {
        this.pinSpacing = pinSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Row Spacing", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getRowSpacing() {
        return this.rowSpacing;
    }

    public void setRowSpacing(Size rowSpacing) {
        this.rowSpacing = rowSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.VALUE;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        this.controlPoints = new Point[this.switchCount.getValue() * 2];
        this.controlPoints[0] = firstPoint;
        double pinSpacing = this.pinSpacing.convertToPixels();
        double rowSpacing = this.rowSpacing.convertToPixels();
        for (int i = 0; i < this.switchCount.getValue(); ++i) {
            double dy2;
            double dx2;
            double dy1;
            double dx1;
            switch (this.orientation) {
                case DEFAULT: {
                    dx1 = 0.0;
                    dy1 = (double)i * pinSpacing;
                    dx2 = rowSpacing;
                    dy2 = (double)i * pinSpacing;
                    break;
                }
                case _90: {
                    dx1 = (double)(-i) * pinSpacing;
                    dy1 = 0.0;
                    dx2 = (double)(-i) * pinSpacing;
                    dy2 = rowSpacing;
                    break;
                }
                case _180: {
                    dx1 = 0.0;
                    dy1 = (double)(-i) * pinSpacing;
                    dx2 = -rowSpacing;
                    dy2 = (double)(-i) * pinSpacing;
                    break;
                }
                case _270: {
                    dx1 = (double)i * pinSpacing;
                    dy1 = 0.0;
                    dx2 = (double)i * pinSpacing;
                    dy2 = -rowSpacing;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.controlPoints[i] = new Point((int)((double)firstPoint.x + dx1), (int)((double)firstPoint.y + dy1));
            this.controlPoints[i + this.switchCount.getValue()] = new Point((int)((double)firstPoint.x + dx2), (int)((double)firstPoint.y + dy2));
        }
    }

    public Area[] getBody() {
        if (this.body == null) {
            double height;
            double width;
            this.body = new Area[3];
            double x = this.controlPoints[0].x;
            double y = this.controlPoints[0].y;
            double pinSpacing = this.pinSpacing.convertToPixels();
            double rowSpacing = this.rowSpacing.convertToPixels();
            double bodyWidth = this.getClosestOdd(this.getWidth().convertToPixels());
            double tickHoleLength = rowSpacing * 2.0 / 3.0;
            double tickSize = PIN_SIZE.convertToPixels();
            Area tickArea = new Area();
            Area tickHoleArea = new Area();
            switch (this.orientation) {
                case DEFAULT: {
                    width = bodyWidth;
                    height = (double)this.switchCount.getValue() * pinSpacing;
                    x -= (bodyWidth - rowSpacing) / 2.0;
                    y -= pinSpacing / 2.0;
                    for (int i = 0; i < this.getSwitchCount().getValue(); ++i) {
                        tickHoleArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x + (rowSpacing - tickHoleLength) / 2.0, (double)this.controlPoints[i].y - tickSize / 2.0, tickHoleLength, tickSize)));
                        tickArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x + (rowSpacing - tickHoleLength) / 2.0, (double)this.controlPoints[i].y - tickSize / 2.0, tickSize, tickSize)));
                    }
                    break;
                }
                case _90: {
                    width = (double)this.switchCount.getValue() * pinSpacing;
                    height = bodyWidth;
                    x -= pinSpacing / 2.0 + width - pinSpacing;
                    y -= (bodyWidth - rowSpacing) / 2.0;
                    for (int i = 0; i < this.getSwitchCount().getValue(); ++i) {
                        tickHoleArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x - tickSize / 2.0, (double)this.controlPoints[i].y + (rowSpacing - tickHoleLength) / 2.0, tickSize, tickHoleLength)));
                        tickArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x - tickSize / 2.0, (double)this.controlPoints[i].y + (rowSpacing - tickHoleLength) / 2.0, tickSize, tickSize)));
                    }
                    break;
                }
                case _180: {
                    width = bodyWidth;
                    height = (double)this.switchCount.getValue() * pinSpacing;
                    x -= rowSpacing + (bodyWidth - rowSpacing) / 2.0;
                    y -= pinSpacing / 2.0 + height - pinSpacing;
                    for (int i = this.getSwitchCount().getValue(); i < this.controlPoints.length; ++i) {
                        tickHoleArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x + (rowSpacing - tickHoleLength) / 2.0, (double)this.controlPoints[i].y - tickSize / 2.0, tickHoleLength, tickSize)));
                        tickArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x + (rowSpacing + tickHoleLength) / 2.0 - tickSize, (double)this.controlPoints[i].y - tickSize / 2.0, tickSize, tickSize)));
                    }
                    break;
                }
                case _270: {
                    width = (double)this.switchCount.getValue() * pinSpacing;
                    height = bodyWidth;
                    x -= pinSpacing / 2.0;
                    y -= rowSpacing + (bodyWidth - rowSpacing) / 2.0;
                    for (int i = this.getSwitchCount().getValue(); i < this.controlPoints.length; ++i) {
                        tickHoleArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x - tickSize / 2.0, (double)this.controlPoints[i].y + (rowSpacing - tickHoleLength) / 2.0, tickSize, tickHoleLength)));
                        tickArea.add(new Area(new Rectangle2D.Double((double)this.controlPoints[i].x - tickSize / 2.0, (double)this.controlPoints[i].y + (rowSpacing - tickHoleLength) / 2.0 + tickHoleLength - tickSize, tickSize, tickSize)));
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.body[0] = new Area(new RoundRectangle2D.Double(x, y, width, height, EDGE_RADIUS, EDGE_RADIUS));
            this.body[1] = tickHoleArea;
            this.body[2] = tickArea;
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Area mainArea = this.getBody()[0];
        if (!outlineMode) {
            int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
            for (Point point : this.controlPoints) {
                g2d.setColor(PIN_COLOR);
                int pinWidth = this.getClosestOdd((float)pinSize / (this.getOrientation() == Orientation.DEFAULT || this.getOrientation() == Orientation._180 ? 2.0f : 1.0f));
                int pinHeight = this.getClosestOdd((float)pinSize / (this.getOrientation() == Orientation.DEFAULT || this.getOrientation() == Orientation._180 ? 1.0f : 2.0f));
                g2d.fillRect(point.x - pinWidth / 2, point.y - pinHeight / 2, pinWidth, pinHeight);
                g2d.setColor(PIN_BORDER_COLOR);
                g2d.drawRect(point.x - pinWidth / 2, point.y - pinHeight / 2, pinWidth, pinHeight);
            }
        }
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBodyColor());
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getBorderColor();
        }
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        if (outlineMode) {
            Area area = new Area(mainArea);
            area.subtract(this.getBody()[1]);
            g2d.draw(area);
            if (this.getBody()[1] != null) {
                g2d.draw(this.getBody()[1]);
            }
            if (this.getBody()[2] != null) {
                g2d.draw(this.getBody()[2]);
            }
        } else {
            g2d.draw(mainArea);
            if (this.getBody()[1] != null) {
                g2d.setColor(this.getTickColor().darker());
                g2d.fill(this.getBody()[1]);
            }
            if (this.getBody()[2] != null) {
                g2d.setColor(this.getTickColor());
                g2d.fill(this.getBody()[2]);
            }
        }
        drawingObserver.stopTracking();
        g2d.setFont(project.getFont());
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor();
        }
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        String[] label = null;
        if (this.getDisplay() == Display.NAME) {
            label = new String[]{this.getName()};
        } else if (this.getDisplay() == Display.VALUE) {
            label = new String[]{this.getValue().toString()};
        } else if (this.getDisplay() == Display.BOTH) {
            String[] stringArray;
            String value = this.getValue().toString();
            if (value.isEmpty()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.getName();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.getName();
                stringArray = stringArray3;
                stringArray3[1] = value;
            }
            label = stringArray;
        }
        if (label != null) {
            for (int i = 0; i < label.length; ++i) {
                String l = label[i];
                Rectangle2D rect = fontMetrics.getStringBounds(l, g2d);
                int textHeight = (int)rect.getHeight();
                int textWidth = (int)rect.getWidth();
                Rectangle bounds = mainArea.getBounds();
                int x = bounds.x + (bounds.width - textWidth) / 2;
                int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
                AffineTransform oldTransform = g2d.getTransform();
                if (this.getOrientation() == Orientation.DEFAULT || this.getOrientation() == Orientation._180) {
                    int centerX = bounds.x + bounds.width / 2;
                    int centerY = bounds.y + bounds.height / 2;
                    g2d.rotate(-1.5707963267948966, centerX, centerY);
                }
                if (label.length == 2) {
                    if (i == 0) {
                        g2d.translate(0, -textHeight / 2);
                    } else if (i == 1) {
                        g2d.translate(0, textHeight / 2);
                    }
                }
                g2d.drawString(l, x, y);
                g2d.setTransform(oldTransform);
            }
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(BODY_COLOR);
        g2d.fillRect(width / 6, 1, 4 * width / 6, height - 4);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(width / 6, 1, 4 * width / 6, height - 4);
        int tickSize = (int)(2.0f * (float)width / 32.0f);
        int tickHoleLength = (int)((double)width * 0.4);
        for (int i = 0; i < 4; ++i) {
            g2d.setColor(TICK_COLOR.darker());
            g2d.fillRect((width - tickHoleLength) / 2, height / 5 * (i + 1) - tickSize / 2, tickHoleLength, tickSize);
            g2d.setColor(TICK_COLOR);
            g2d.fillRect((width - tickHoleLength) / 2, height / 5 * (i + 1) - tickSize / 2, tickSize, tickSize);
        }
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        if (this.bodyColor == null) {
            this.bodyColor = BODY_COLOR;
        }
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = BORDER_COLOR;
        }
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty(name="Tick")
    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color tickColor) {
        this.tickColor = tickColor;
    }

    @EditableProperty(validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getWidth() {
        return this.width;
    }

    public void setWidth(Size width) {
        this.width = width;
        this.body = null;
    }

    public int getPositionCount() {
        return (int)Math.pow(2.0, this.getSwitchCount().getValue());
    }

    public String getPositionName(int position) {
        String binary = this.toBinary(position);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getSwitchCount().getValue(); ++i) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(binary.charAt(i) == '0' ? "OFF" : "ON");
        }
        return sb.toString();
    }

    public boolean arePointsConnected(int index1, int index2, int position) {
        String binary = this.toBinary(position);
        return Math.abs(index1 - index2) == this.getSwitchCount().getValue() && binary.charAt(index1 < index2 ? index1 : index2) == '1';
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    private String toBinary(int n) {
        StringBuilder builder = new StringBuilder();
        do {
            builder.append(n % 2);
        } while ((n /= 2) > 0);
        while (builder.length() < this.getSwitchCount().getValue()) {
            builder.append("0");
        }
        return builder.toString();
    }

    public static enum SwitchCount {
        _2,
        _3,
        _4,
        _5,
        _6,
        _7,
        _8,
        _9,
        _10,
        _11,
        _12;


        public String toString() {
            return this.name().replace("_", "");
        }

        public int getValue() {
            return Integer.parseInt(this.toString());
        }
    }
}

