/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Turret Lug", category="Connectivity", author="Branislav Stojkovic", description="Turret terminal lug", instanceNamePrefix="Turret", zOrder=3.1, bomPolicy=BomPolicy.SHOW_ONLY_TYPE_NAME, autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TYPE_NAME, transformer=SimpleComponentTransformer.class)
public class Turret
extends AbstractComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size SIZE = new Size(Double.valueOf(0.16), SizeUnit.in);
    public static Size HOLE_SIZE = new Size(Double.valueOf(0.0625), SizeUnit.in);
    public static Color COLOR = Color.decode("#E0C04C");
    private Size size = SIZE;
    private Size holeSize = HOLE_SIZE;
    private Color color = COLOR;
    private Point point = new Point(0, 0);
    private String value = "";

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int diameter = this.getClosestOdd((int)this.size.convertToPixels());
        int holeDiameter = this.getClosestOdd((int)this.holeSize.convertToPixels());
        g2d.setColor(this.color);
        g2d.setStroke(ObjectCache.getInstance().fetchZoomableStroke(1.0f));
        drawingObserver.startTrackingContinuityArea(true);
        g2d.fillOval(this.point.x - diameter / 2, this.point.y - diameter / 2, diameter, diameter);
        drawingObserver.stopTrackingContinuityArea();
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color.darker());
        g2d.drawOval(this.point.x - diameter / 2, this.point.y - diameter / 2, diameter, diameter);
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval(this.point.x - holeDiameter / 2, this.point.y - holeDiameter / 2, holeDiameter, holeDiameter);
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color.darker());
        g2d.drawOval(this.point.x - holeDiameter / 2, this.point.y - holeDiameter / 2, holeDiameter, holeDiameter);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int diameter = this.getClosestOdd(width / 2);
        int holeDiameter = 5;
        g2d.setColor(COLOR);
        g2d.fillOval((width - diameter) / 2, (height - diameter) / 2, diameter, diameter);
        g2d.setColor(COLOR.darker());
        g2d.drawOval((width - diameter) / 2, (height - diameter) / 2, diameter, diameter);
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval((width - holeDiameter) / 2, (height - holeDiameter) / 2, holeDiameter, holeDiameter);
        g2d.setColor(COLOR.darker());
        g2d.drawOval((width - holeDiameter) / 2, (height - holeDiameter) / 2, holeDiameter, holeDiameter);
    }

    @EditableProperty
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @EditableProperty(name="Hole size")
    public Size getHoleSize() {
        return this.holeSize;
    }

    public void setHoleSize(Size holeSize) {
        this.holeSize = holeSize;
    }

    public String getName() {
        return super.getName();
    }

    public int getControlPointCount() {
        return 1;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty(name="Color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getControlPointNodeName(int index) {
        return null;
    }
}

