/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.boards;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.awt.StringUtils;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

public abstract class AbstractBoard
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color BOARD_COLOR = Color.decode("#F8EBB3");
    public static Color BORDER_COLOR = BOARD_COLOR.darker();
    public static Color COORDINATE_COLOR = Color.gray.brighter();
    public static float COORDINATE_FONT_SIZE = 9.0f;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(1.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(1.2), SizeUnit.in);
    protected String value = "";
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point((int)DEFAULT_WIDTH.convertToPixels(), (int)DEFAULT_HEIGHT.convertToPixels())};
    protected Point firstPoint = new Point();
    protected Point secondPoint = new Point();
    protected Color boardColor = BOARD_COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected Color coordinateColor = COORDINATE_COLOR;
    protected Boolean drawCoordinates = null;
    protected CoordinateType xType = CoordinateType.Numbers;
    protected CoordinateOrigin coordinateOrigin = CoordinateOrigin.Top_Left;
    protected CoordinateDisplay coordinateDisplay = CoordinateDisplay.One_Side;
    protected CoordinateType yType = CoordinateType.Letters;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        byte alpha;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Composite oldComposite = g2d.getComposite();
        byte by = alpha = componentState == ComponentState.DRAGGING ? (byte)0 : this.alpha;
        if (alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(this.boardColor);
        g2d.fillRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
        g2d.setComposite(oldComposite);
        drawingObserver.stopTracking();
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.drawRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
    }

    protected void drawCoordinates(Graphics2D g2d, int spacing, Project project) {
        int c;
        int range;
        Point drawPoint;
        g2d.setColor(this.coordinateColor);
        g2d.setFont(project.getFont().deriveFont(COORDINATE_FONT_SIZE));
        int halfSpace = spacing / 2;
        CoordinateOrigin origin = this.getCoordinateOrigin();
        if (this.getCoordinateDisplay() != CoordinateDisplay.None) {
            int yOffset;
            CoordinateType yType = this.getyType();
            drawPoint = new Point(this.firstPoint);
            if (origin == CoordinateOrigin.Top_Left || origin == CoordinateOrigin.Top_Right) {
                range = (this.secondPoint.y - this.firstPoint.y + halfSpace) / spacing;
                yOffset = spacing;
            } else {
                range = (this.secondPoint.y - this.firstPoint.y + halfSpace) / spacing;
                yOffset = -spacing;
                drawPoint.y = this.secondPoint.y;
            }
            for (c = 1; c < range; ++c) {
                int xOffset = yType == CoordinateType.Numbers && c >= 10 || yType == CoordinateType.Letters && c >= 27 ? 0 : 2;
                String label = yType == CoordinateType.Letters ? this.getCoordinateLabel(c) : Integer.toString(c);
                drawPoint.y += yOffset;
                StringUtils.drawCenteredText(g2d, label, this.firstPoint.x + xOffset, drawPoint.y, HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
                if (this.getCoordinateDisplay() != CoordinateDisplay.Both_Sides) continue;
                StringUtils.drawCenteredText(g2d, label, this.secondPoint.x - xOffset, drawPoint.y, HorizontalAlignment.RIGHT, VerticalAlignment.CENTER);
            }
        }
        if (this.getCoordinateDisplay() != CoordinateDisplay.None) {
            int xOffset;
            CoordinateType xType = this.getxType();
            drawPoint = new Point(this.firstPoint);
            if (origin == CoordinateOrigin.Top_Left || origin == CoordinateOrigin.Bottom_Left) {
                range = (this.secondPoint.x - this.firstPoint.x + halfSpace) / spacing;
                xOffset = spacing;
            } else {
                range = (this.secondPoint.x - this.firstPoint.x + halfSpace) / spacing;
                xOffset = -spacing;
                drawPoint.x = this.secondPoint.x;
            }
            for (c = 1; c < range; ++c) {
                String label = xType == CoordinateType.Letters ? this.getCoordinateLabel(c) : Integer.toString(c);
                drawPoint.x += xOffset;
                StringUtils.drawCenteredText(g2d, label, drawPoint.x, this.firstPoint.y - 2, HorizontalAlignment.CENTER, VerticalAlignment.TOP);
                if (this.getCoordinateDisplay() != CoordinateDisplay.Both_Sides) continue;
                StringUtils.drawCenteredText(g2d, label, drawPoint.x, (int)((float)this.secondPoint.y - COORDINATE_FONT_SIZE), HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
            }
        }
    }

    private String getCoordinateLabel(int coordinate) {
        String result = "";
        while (coordinate > 0) {
            int digit = coordinate % 26;
            coordinate /= 26;
            if (digit == 0) {
                result = 'Z' + result;
                --coordinate;
                continue;
            }
            result = (char)(65 + digit - 1) + result;
        }
        return result;
    }

    @EditableProperty(name="Color")
    public Color getBoardColor() {
        return this.boardColor;
    }

    public void setBoardColor(Color boardColor) {
        this.boardColor = boardColor;
    }

    @EditableProperty(name="Coordinate Color")
    public Color getCoordinateColor() {
        return this.coordinateColor == null ? COORDINATE_COLOR : this.coordinateColor;
    }

    public void setCoordinateColor(Color coordinateColor) {
        this.coordinateColor = coordinateColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="X")
    public CoordinateType getxType() {
        if (this.xType == null) {
            this.xType = CoordinateType.Numbers;
        }
        return this.xType;
    }

    public void setxType(CoordinateType xType) {
        this.xType = xType;
    }

    @EditableProperty(name="Coordinates")
    public CoordinateDisplay getCoordinateDisplay() {
        if (this.coordinateDisplay == null) {
            this.coordinateDisplay = CoordinateDisplay.One_Side;
        }
        return this.coordinateDisplay;
    }

    public void setCoordinateDisplay(CoordinateDisplay coordinateDisplay) {
        this.coordinateDisplay = coordinateDisplay;
    }

    @EditableProperty(name="Coordinate Origin")
    public CoordinateOrigin getCoordinateOrigin() {
        if (this.coordinateOrigin == null) {
            this.coordinateOrigin = CoordinateOrigin.Top_Left;
        }
        return this.coordinateOrigin;
    }

    public void setCoordinateOrigin(CoordinateOrigin coordinateOrigin) {
        this.coordinateOrigin = coordinateOrigin;
    }

    @EditableProperty(name="Y")
    public CoordinateType getyType() {
        if (this.yType == null) {
            this.yType = CoordinateType.Letters;
        }
        return this.yType;
    }

    public void setyType(CoordinateType yType) {
        this.yType = yType;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.firstPoint.setLocation(Math.min(this.controlPoints[0].x, this.controlPoints[1].x), Math.min(this.controlPoints[0].y, this.controlPoints[1].y));
        this.secondPoint.setLocation(Math.max(this.controlPoints[0].x, this.controlPoints[1].x), Math.max(this.controlPoints[0].y, this.controlPoints[1].y));
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static enum CoordinateOrigin {
        Top_Left,
        Top_Right,
        Bottom_Right,
        Bottom_Left;


        public String toString() {
            return super.toString().replace('_', ' ');
        }
    }

    public static enum CoordinateDisplay {
        None,
        One_Side,
        Both_Sides;


        public String toString() {
            return super.toString().replace('_', ' ');
        }
    }

    public static enum CoordinateType {
        Letters,
        Numbers;

    }
}

