/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.geom.GeneralPath;

public class RoundedPath {
    private GeneralPath path;
    boolean isFirst = true;
    private double x = Double.NaN;
    private double y = Double.NaN;
    private double radius;

    public RoundedPath(double radius) {
        this.radius = radius;
        this.path = new GeneralPath();
    }

    public final void moveTo(double x, double y) {
        this.path.moveTo(x, y);
        this.x = x;
        this.y = y;
        this.isFirst = true;
    }

    public final void lineTo(double x, double y) {
        if (this.isFirst) {
            double theta = Math.atan2(y - this.y, x - this.x);
            double r = Math.sqrt((y - this.y) * (y - this.y) + (x - this.x) * (x - this.x));
            this.path.lineTo(this.x + Math.cos(theta) * (r - this.radius), this.y + Math.sin(theta) * (r - this.radius));
        } else {
            double theta = Math.atan2(y - this.y, x - this.x);
            this.path.curveTo(this.x, this.y, this.x, this.y, this.x + Math.cos(theta) * this.radius, this.y + Math.sin(theta) * this.radius);
        }
        this.isFirst = false;
        this.x = x;
        this.y = y;
    }

    public GeneralPath getPath() {
        return this.path;
    }
}

