/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import org.diylc.common.LabelPosition;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.annotations.EditableProperty;

public abstract class AbstractSchematicLeadedSymbol<T>
extends AbstractLeadedComponent<T> {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.blue;
    public static Color LEAD_COLOR = Color.black;
    protected LabelPosition labelPosition = LabelPosition.ABOVE;

    public AbstractSchematicLeadedSymbol() {
        this.bodyColor = null;
        this.leadColor = LEAD_COLOR;
        this.borderColor = COLOR;
    }

    @Override
    public Color getBodyColor() {
        return super.getBodyColor();
    }

    @Override
    protected boolean shouldShadeLeads() {
        return false;
    }

    @Override
    protected float getLeadThickness() {
        return 1.0f;
    }

    @Override
    protected int calculateLabelYOffset(Rectangle2D shapeRect, Rectangle2D textRect, FontMetrics fontMetrics) {
        if (this.labelPosition == LabelPosition.ABOVE) {
            return -5;
        }
        return (int)(shapeRect.getHeight() + textRect.getHeight());
    }

    @Override
    protected Point calculateLabelPosition(Point point1, Point point2) {
        double x = (double)(point1.x + point2.x) / 2.0;
        double y = (double)(point1.y + point2.y) / 2.0;
        double theta = Math.atan2(point2.y - point1.y, point2.x - point2.x) - 1.5707963267948966;
        double r = this.width.convertToPixels() / 2.0 + (double)(LABEL_FONT.getSize() / 2);
        return new Point((int)(x + Math.cos(theta) * r), (int)(y + Math.sin(theta) * r));
    }

    @EditableProperty(name="Label Position")
    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    @EditableProperty(name="Color")
    public Color getBorderColor() {
        return super.getBorderColor();
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    @Override
    protected Color getLeadColorForPainting(ComponentState componentState) {
        return componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getLeadColor();
    }
}

