/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.miscutils;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;

public class NewLogForEachRunFileAppender
extends FileAppender {
    private double deleteOlderThan = 6.048E8;

    public NewLogForEachRunFileAppender() {
    }

    public NewLogForEachRunFileAppender(Layout layout, String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super(layout, filename, append, bufferedIO, bufferSize);
    }

    public NewLogForEachRunFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public NewLogForEachRunFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.fileName = this.getNewLogFileName();
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
            }
            catch (Exception e) {
                this.errorHandler.error("Error while activating log options", e, 4);
            }
        }
    }

    private String getNewLogFileName() {
        if (this.fileName != null) {
            String toret = "";
            String DOT = ".";
            String HIPHEN = "-";
            File logFile = new File(this.fileName);
            String fileName = logFile.getName();
            String newFileName = "";
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh.mm.ss");
            int dotIndex = fileName.indexOf(".");
            newFileName = dotIndex != -1 ? fileName.substring(0, dotIndex) + "-" + df.format(new Date()) + "." + fileName.substring(dotIndex + 1) : fileName + "-" + df.format(new Date());
            if (logFile.getParentFile().exists()) {
                if (this.deleteOlderThan > 0.0) {
                    for (File f : logFile.getParentFile().listFiles()) {
                        double age = System.currentTimeMillis() - f.lastModified();
                        if (!(age > this.deleteOlderThan)) continue;
                        f.delete();
                    }
                }
            } else {
                logFile.getParentFile().mkdirs();
            }
            toret = logFile.getParent() + File.separator + newFileName;
            return toret;
        }
        return null;
    }
}

