/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.miscutils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.log4j.Logger;

public class ClassLoaderUtil {
    private static Logger LOG = Logger.getLogger(ClassLoaderUtil.class);
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        ClassLoaderUtil.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        LOG.info((Object)("Adding file to the classpath: " + f.getAbsolutePath()));
        ClassLoaderUtil.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = sysLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toString().equalsIgnoreCase(u.toString())) continue;
            LOG.debug((Object)("URL " + u + " is already in the classpath."));
            return;
        }
        Class<URLClassLoader> sysClass = URLClassLoader.class;
        try {
            Method method = sysClass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, u);
        }
        catch (Throwable t) {
            LOG.error((Object)"Error, could not add URL to system classloader", t);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

