/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import java.util.Comparator;
import org.diylc.common.ComponentType;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Project;
import org.diylc.presenter.ComponentProcessor;

public class ComparatorFactory {
    private static ComparatorFactory instance;
    private Comparator<IDIYComponent<?>> componentNameComparator;
    private Comparator<ComponentType> componentTypeComparator;
    private Comparator<PropertyWrapper> propertyNameComparator;
    private Comparator<IDIYComponent<?>> componentZOrderComparator;

    public static ComparatorFactory getInstance() {
        if (instance == null) {
            instance = new ComparatorFactory();
        }
        return instance;
    }

    public Comparator<IDIYComponent<?>> getComponentNameComparator() {
        if (this.componentNameComparator == null) {
            this.componentNameComparator = new Comparator<IDIYComponent<?>>(){

                @Override
                public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                    String string = iDIYComponent.getName();
                    String string2 = iDIYComponent2.getName();
                    if (string == null || string2 == null) {
                        return 0;
                    }
                    return string.compareToIgnoreCase(string2);
                }
            };
        }
        return this.componentNameComparator;
    }

    public Comparator<ComponentType> getComponentTypeComparator() {
        if (this.componentTypeComparator == null) {
            this.componentTypeComparator = new Comparator<ComponentType>(){

                @Override
                public int compare(ComponentType componentType, ComponentType componentType2) {
                    return componentType.getName().compareToIgnoreCase(componentType2.getName());
                }
            };
        }
        return this.componentTypeComparator;
    }

    public Comparator<PropertyWrapper> getPropertyNameComparator() {
        if (this.propertyNameComparator == null) {
            this.propertyNameComparator = new Comparator<PropertyWrapper>(){

                @Override
                public int compare(PropertyWrapper propertyWrapper, PropertyWrapper propertyWrapper2) {
                    return propertyWrapper.getName().compareToIgnoreCase(propertyWrapper2.getName());
                }
            };
        }
        return this.propertyNameComparator;
    }

    public Comparator<PropertyWrapper> getDefaultPropertyComparator() {
        if (this.propertyNameComparator == null) {
            this.propertyNameComparator = new Comparator<PropertyWrapper>(){

                @Override
                public int compare(PropertyWrapper propertyWrapper, PropertyWrapper propertyWrapper2) {
                    int n = new Integer(propertyWrapper.getSortOrder()).compareTo(propertyWrapper2.getSortOrder());
                    if (n != 0) {
                        return n;
                    }
                    return propertyWrapper.getName().compareToIgnoreCase(propertyWrapper2.getName());
                }
            };
        }
        return this.propertyNameComparator;
    }

    public Comparator<IDIYComponent<?>> getComponentZOrderComparator() {
        if (this.componentZOrderComparator == null) {
            this.componentZOrderComparator = new Comparator<IDIYComponent<?>>(){

                @Override
                public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                    ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
                    ComponentType componentType2 = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent2.getClass());
                    return new Double(componentType.getZOrder()).compareTo(componentType2.getZOrder());
                }
            };
        }
        return this.componentZOrderComparator;
    }

    public Comparator<IDIYComponent<?>> getComponentProjectZOrderComparator(final Project project) {
        return new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                int n = project.getComponents().indexOf(iDIYComponent);
                int n2 = project.getComponents().indexOf(iDIYComponent2);
                return new Integer(n).compareTo(n2);
            }
        };
    }
}

