/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.netlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.diylc.core.IDIYComponent;
import org.diylc.netlist.TreeConnectionType;
import org.diylc.netlist.TreeLeaf;

public class Tree {
    private List<Tree> children;
    private TreeConnectionType connectionType;
    private TreeLeaf leaf;

    public Tree(TreeConnectionType treeConnectionType) {
        this.children = new ArrayList<Tree>();
        this.connectionType = treeConnectionType;
    }

    public Tree(TreeLeaf treeLeaf) {
        this.leaf = treeLeaf;
    }

    public Tree(List<Tree> list, TreeConnectionType treeConnectionType) {
        this.children = list;
        this.connectionType = treeConnectionType;
    }

    public List<Tree> getChildren() {
        return this.children;
    }

    public void trimChildrenLeft(int n) {
        this.children = this.children.subList(n, this.children.size());
    }

    public void trimChildrenRight(int n) {
        this.children = this.children.subList(0, this.children.size() - n);
    }

    public TreeConnectionType getConnectionType() {
        return this.connectionType;
    }

    public TreeLeaf getLeaf() {
        return this.leaf;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.children == null ? 0 : ((Object)this.children).hashCode());
        n = 31 * n + (this.connectionType == null ? 0 : this.connectionType.hashCode());
        n = 31 * n + (this.leaf == null ? 0 : this.leaf.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tree tree = (Tree)object;
        if (this.children == null ? tree.children != null : !((Object)this.children).equals(tree.children)) {
            return false;
        }
        if (this.connectionType != tree.connectionType) {
            return false;
        }
        return !(this.leaf == null ? tree.leaf != null : !this.leaf.equals(tree.leaf));
    }

    private List<Tree> getOrderedChildren() {
        if (this.getConnectionType() == TreeConnectionType.Series) {
            return this.children;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>(this.children);
        Collections.sort(arrayList, new Comparator<Tree>(){

            @Override
            public int compare(Tree tree, Tree tree2) {
                return tree.toString().compareToIgnoreCase(tree2.toString());
            }
        });
        return arrayList;
    }

    public String toString() {
        if (this.leaf != null) {
            return this.leaf.toString();
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        boolean bl = true;
        for (Tree tree : this.getOrderedChildren()) {
            if (!bl) {
                stringBuilder.append(" ").append((Object)this.connectionType).append(" ");
            }
            bl = false;
            stringBuilder.append(tree);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toHTML(int n) {
        if (this.leaf != null) {
            return this.leaf.toHTML();
        }
        List<Tree> list = this.getOrderedChildren();
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0 && list.size() > 1) {
            stringBuilder.append("(");
        }
        boolean bl = true;
        for (Tree tree : list) {
            if (!bl) {
                stringBuilder.append("&nbsp;").append(this.connectionType.toHTML()).append("&nbsp;");
                if (n == 0) {
                    stringBuilder.append("<br>");
                }
            }
            bl = false;
            stringBuilder.append(tree.toHTML(n + list.size() > 1 ? 1 : 0));
        }
        if (n > 0 && list.size() > 1) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.leaf != null) {
            return new Tree(this.leaf);
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (Tree tree : this.children) {
            arrayList.add((Tree)tree.clone());
        }
        return new Tree(arrayList, this.connectionType);
    }

    public Tree filter(Set<String> set) {
        if (this.leaf != null) {
            if (set.contains(this.leaf.getComponent().getClass().getCanonicalName())) {
                return new Tree(this.leaf);
            }
            return null;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (Tree tree : this.children) {
            Tree tree2 = tree.filter(set);
            if (tree2 == null) continue;
            arrayList.add(tree2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new Tree(arrayList, this.connectionType);
    }

    public void walk(ITreeWalker iTreeWalker) {
        if (this.leaf != null) {
            iTreeWalker.visit(this.leaf);
        } else {
            for (Tree tree : this.children) {
                iTreeWalker.visit(tree);
                tree.walk(iTreeWalker);
            }
        }
    }

    public Set<IDIYComponent<?>> extractComponents(Set<String> set) {
        HashSet hashSet = new HashSet();
        if (this.leaf != null && set.contains(this.leaf.getComponent().getClass().getCanonicalName())) {
            hashSet.add(this.leaf.getComponent());
        } else if (this.children != null) {
            for (Tree tree : this.children) {
                Set<IDIYComponent<?>> set2 = tree.extractComponents(set);
                if (set2 == null) continue;
                hashSet.addAll(set2);
            }
        }
        return hashSet;
    }

    public Tree locate(TreeLeaf treeLeaf, boolean bl) {
        if (this.leaf != null && this.leaf.equals(treeLeaf, bl)) {
            return this;
        }
        if (this.children != null) {
            for (Tree tree : this.children) {
                Tree tree2 = tree.locate(treeLeaf, bl);
                if (tree2 == null) continue;
                return tree2;
            }
        }
        return null;
    }

    public Tree findCommonParent(Tree tree, Tree tree2) {
        if (tree == null) {
            return tree2;
        }
        if (tree2 == null) {
            return tree;
        }
        if (this.children == null) {
            return null;
        }
        if (!this.contains(tree) || !this.contains(tree2)) {
            return null;
        }
        Tree tree3 = this;
        Tree tree4 = this;
        for (Tree tree5 : this.children) {
            if (tree5.contains(tree)) {
                tree3 = tree5;
            }
            if (!tree5.contains(tree2)) continue;
            tree4 = tree5;
        }
        if (tree3 != tree4 || tree3 == this || tree4 == this) {
            return this;
        }
        return tree3.findCommonParent(tree, tree2);
    }

    public Tree findCommonParent(List<Tree> list) {
        if (list.contains(null)) {
            while (list.contains(null)) {
                list.remove(null);
            }
            return this.findCommonParent(list);
        }
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 2) {
            return this.findCommonParent(list.get(0), list.get(1));
        }
        List<Tree> list2 = list.subList(1, list.size());
        return this.findCommonParent(list.get(0), this.findCommonParent(list2));
    }

    public Tree findParent(Tree tree) {
        if (this.children == null) {
            return null;
        }
        if (this.children.contains(tree)) {
            return this;
        }
        for (Tree tree2 : this.children) {
            Tree tree3 = tree2.findParent(tree);
            if (tree3 == null) continue;
            return tree3;
        }
        return null;
    }

    public boolean contains(Tree tree) {
        if (this == tree) {
            return true;
        }
        if (this.children == null) {
            return false;
        }
        if (this.children.contains(tree)) {
            return true;
        }
        for (Tree tree2 : this.children) {
            if (!tree2.contains(tree)) continue;
            return true;
        }
        return false;
    }

    public static interface ITreeWalker {
        public void visit(Tree var1);

        public void visit(TreeLeaf var1);
    }
}

