/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.netlist;

import org.diylc.core.IDIYComponent;

public class Node
implements Comparable<Node> {
    private IDIYComponent<?> component;
    private int pointIndex;

    public Node(IDIYComponent<?> iDIYComponent, int n) {
        this.component = iDIYComponent;
        this.pointIndex = n;
    }

    public IDIYComponent<?> getComponent() {
        return this.component;
    }

    public int getPointIndex() {
        return this.pointIndex;
    }

    public String getDisplayName() {
        String[] stringArray = this.component.getSectionNames(this.pointIndex);
        return (stringArray == null || stringArray.length > 1 ? "" : stringArray[0] + ".") + this.component.getControlPointNodeName(this.pointIndex);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.component == null ? 0 : this.component.hashCode());
        n = 31 * n + this.pointIndex;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Node node = (Node)object;
        if (this.component == null ? node.component != null : !this.component.equals(node.component)) {
            return false;
        }
        return this.pointIndex == node.pointIndex;
    }

    public String toString() {
        if (this.component.getControlPointCount() == 1) {
            return this.component.getName();
        }
        return this.component.getName() + "." + this.getDisplayName();
    }

    @Override
    public int compareTo(Node node) {
        return this.toString().compareToIgnoreCase(node.toString());
    }
}

