/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.netlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.diylc.netlist.Group;
import org.diylc.netlist.SwitchSetup;

public class Netlist
implements Comparable<Netlist> {
    private Set<Group> groups = new HashSet<Group>();
    private List<SwitchSetup> switchSetup = new ArrayList<SwitchSetup>();

    public Set<Group> getGroups() {
        return this.groups;
    }

    public Netlist add(Group group) {
        this.groups.add(group);
        return this;
    }

    public List<Group> getSortedGroups() {
        ArrayList<Group> arrayList = new ArrayList<Group>(this.groups);
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<SwitchSetup> getSwitchSetup() {
        return this.switchSetup;
    }

    public void done() {
        Collections.sort(this.switchSetup);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.groups == null ? 0 : ((Object)this.groups).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Netlist netlist = (Netlist)object;
        return !(this.groups == null ? netlist.groups != null : !((Object)this.groups).equals(netlist.groups));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        List<Group> list = this.getSortedGroups();
        for (Group group : list) {
            stringBuilder.append("\t").append(group).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Netlist netlist) {
        return this.switchSetup.toString().compareToIgnoreCase(netlist.switchSetup.toString());
    }
}

