/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.netlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.diylc.core.IDIYComponent;
import org.diylc.netlist.Node;

public class Group
implements Comparable<Group> {
    private Set<Node> nodes = new HashSet<Node>();

    public Group() {
    }

    public Group(Node node, Node node2) {
        this.nodes.add(node);
        this.nodes.add(node2);
    }

    public Group connect(IDIYComponent<?> iDIYComponent, int n) {
        this.getNodes().add(new Node(iDIYComponent, n));
        return this;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public List<Node> getSortedNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodes);
        Collections.sort(arrayList);
        return arrayList;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.nodes == null ? 0 : ((Object)this.nodes).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Group group = (Group)object;
        return !(this.nodes == null ? group.nodes != null : !((Object)this.nodes).equals(group.nodes));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        List<Node> list = this.getSortedNodes();
        for (Node node : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" <-> ");
            }
            stringBuilder.append(node);
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Group group) {
        return this.toString().compareToIgnoreCase(group.toString());
    }

    public Group clone() {
        Group group = new Group();
        group.nodes.addAll(this.nodes);
        return group;
    }
}

