/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.Utils;

public class UpdateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JEditorPane htmlLabel;
    private String htmlText;
    private String latestVersionUrl;

    public UpdateDialog(JComponent owner, String htmlText, String latestVersionUrl) {
        super(SwingUtilities.getWindowAncestor(owner));
        this.htmlText = htmlText;
        this.latestVersionUrl = latestVersionUrl;
        this.setTitle(latestVersionUrl == null ? "Version History" : "Update Details");
        this.setModal(true);
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new BorderLayout());
        holderPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        holderPanel.add((Component)new JLabel(latestVersionUrl == null ? "Most recent updates on this computer:" : "These updates are available for your computer:"), "North");
        final JScrollPane scrollPane = new JScrollPane(this.getHtmlLabel());
        scrollPane.setHorizontalScrollBarPolicy(31);
        holderPanel.add((Component)scrollPane, "Center");
        holderPanel.add((Component)this.createButtonPanel(), "South");
        this.setContentPane(holderPanel);
        this.setPreferredSize(new Dimension(480, 400));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        if (this.latestVersionUrl != null) {
            JButton downloadButton = new JButton("Download");
            downloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Utils.openURL((String)UpdateDialog.this.latestVersionUrl);
                        UpdateDialog.this.setVisible(false);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(UpdateDialog.this, "Could not launch default browser. To downlaod the latest version visit " + UpdateDialog.this.latestVersionUrl);
                        Logger.getLogger(UpdateDialog.class).error((Object)"Could not launch default browser", (Throwable)e1);
                    }
                }
            });
            buttonPanel.add(downloadButton);
            buttonPanel.add(Box.createHorizontalStrut(4));
        }
        JButton cancelButton = new JButton("Close");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public JEditorPane getHtmlLabel() {
        if (this.htmlLabel == null) {
            this.htmlLabel = new JEditorPane();
            this.htmlLabel.setEditable(false);
            this.htmlLabel.setContentType("text/html");
            this.htmlLabel.setText(this.htmlText);
            this.htmlLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        }
        return this.htmlLabel;
    }
}

