/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.ruler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.diylc.appframework.images.IconLoader;
import org.diylc.swingframework.IDrawingProvider;
import org.diylc.swingframework.images.CursorLoader;
import org.diylc.swingframework.ruler.ComponentThumbnailProvider;
import org.diylc.swingframework.ruler.IRulerListener;
import org.diylc.swingframework.ruler.NavigateDialog;
import org.diylc.swingframework.ruler.Ruler;

public class RulerScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private Ruler horizontalRuler;
    private Ruler verticalRuler;
    private JButton unitButton;
    private JButton navigateButton;
    private Corner topRightCorner;
    private Corner bottomLeftCorner;
    private List<IRulerListener> listeners;
    private boolean mouseScrollMode = false;
    private Point mouseScrollPrevLocation = null;
    private static double MOUSE_SCROLL_SPEED = 0.8;

    public RulerScrollPane(Component view) {
        this(view, new ComponentThumbnailProvider(view));
    }

    public RulerScrollPane(Component view, IDrawingProvider provider) {
        this(view, provider, 0.0, 0.0);
    }

    public RulerScrollPane(final Component view, final IDrawingProvider provider, double cmSpacing, double inSpacing) {
        super(view);
        this.horizontalRuler = new Ruler(0, true, cmSpacing, inSpacing);
        this.verticalRuler = new Ruler(1, true, cmSpacing, inSpacing);
        this.setColumnHeaderView(this.horizontalRuler);
        this.setRowHeaderView(this.verticalRuler);
        this.listeners = new ArrayList<IRulerListener>();
        view.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!RulerScrollPane.this.mouseScrollMode && e.getButton() == 2) {
                    RulerScrollPane.this.mouseScrollPrevLocation = null;
                    RulerScrollPane.this.mouseScrollMode = true;
                    view.setCursor(CursorLoader.ScrollCenter.getCursor());
                    e.consume();
                } else if (RulerScrollPane.this.mouseScrollMode) {
                    RulerScrollPane.this.mouseScrollMode = false;
                    view.setCursor(Cursor.getDefaultCursor());
                    e.consume();
                }
            }
        });
        view.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (RulerScrollPane.this.mouseScrollMode) {
                    if (RulerScrollPane.this.mouseScrollPrevLocation != null) {
                        int dx = (int)((double)(e.getPoint().x - ((RulerScrollPane)RulerScrollPane.this).mouseScrollPrevLocation.x) * MOUSE_SCROLL_SPEED);
                        int dy = (int)((double)(e.getPoint().y - ((RulerScrollPane)RulerScrollPane.this).mouseScrollPrevLocation.y) * MOUSE_SCROLL_SPEED);
                        RulerScrollPane.this.getHorizontalScrollBar().setValue(RulerScrollPane.this.getHorizontalScrollBar().getValue() + dx);
                        RulerScrollPane.this.getVerticalScrollBar().setValue(RulerScrollPane.this.getVerticalScrollBar().getValue() + dy);
                        if (Math.abs(dx) > 2 * Math.abs(dy)) {
                            view.setCursor(dx > 0 ? CursorLoader.ScrollE.getCursor() : CursorLoader.ScrollW.getCursor());
                        } else if (Math.abs(dy) > 2 * Math.abs(dx)) {
                            view.setCursor(dy > 0 ? CursorLoader.ScrollS.getCursor() : CursorLoader.ScrollN.getCursor());
                        } else if (dx > 0 && dy > 0) {
                            view.setCursor(CursorLoader.ScrollSE.getCursor());
                        } else if (dx > 0 && dy < 0) {
                            view.setCursor(CursorLoader.ScrollNE.getCursor());
                        } else if (dx < 0 && dy < 0) {
                            view.setCursor(CursorLoader.ScrollNW.getCursor());
                        } else if (dx < 0 && dy > 0) {
                            view.setCursor(CursorLoader.ScrollSW.getCursor());
                        }
                    }
                    RulerScrollPane.this.mouseScrollPrevLocation = e.getPoint();
                    e.consume();
                }
            }
        });
        view.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RulerScrollPane.this.updateRulerSize(e.getComponent().getWidth(), e.getComponent().getHeight());
            }
        });
        this.updateRulerSize(view.getWidth(), view.getHeight());
        this.unitButton = new JButton("cm");
        this.unitButton.setToolTipText("Toggle metric/imperial system");
        this.unitButton.setMargin(new Insets(0, 0, 0, 0));
        this.unitButton.setFont(this.unitButton.getFont().deriveFont(9.0f));
        this.unitButton.setFocusable(false);
        this.unitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RulerScrollPane.this.horizontalRuler.isMetric()) {
                    RulerScrollPane.this.horizontalRuler.setIsMetric(false);
                    RulerScrollPane.this.verticalRuler.setIsMetric(false);
                    RulerScrollPane.this.unitButton.setText("in");
                } else {
                    RulerScrollPane.this.horizontalRuler.setIsMetric(true);
                    RulerScrollPane.this.verticalRuler.setIsMetric(true);
                    RulerScrollPane.this.unitButton.setText("cm");
                }
                for (IRulerListener listener : RulerScrollPane.this.listeners) {
                    listener.unitsChanged(RulerScrollPane.this.horizontalRuler.isMetric());
                }
            }
        });
        this.navigateButton = new JButton(IconLoader.MoveSmall.getIcon());
        this.navigateButton.setToolTipText("Auto-scroll");
        this.navigateButton.setFocusable(false);
        this.navigateButton.setMargin(new Insets(0, 0, 0, 0));
        this.navigateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigateDialog navigateDialog = new NavigateDialog(RulerScrollPane.this, provider);
                navigateDialog.setVisible(true);
                navigateDialog.setLocationRelativeTo(RulerScrollPane.this.navigateButton);
            }
        });
        this.topRightCorner = new Corner(0);
        this.bottomLeftCorner = new Corner(1);
        this.setCorner("UPPER_LEFT_CORNER", this.unitButton);
        this.setCorner("UPPER_RIGHT_CORNER", this.topRightCorner);
        this.setCorner("LOWER_LEFT_CORNER", this.bottomLeftCorner);
        this.setCorner("LOWER_RIGHT_CORNER", this.navigateButton);
        view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("dragPoint")) {
                    RulerScrollPane.this.horizontalRuler.setIndicatorValue(((Long)evt.getOldValue()).intValue());
                    RulerScrollPane.this.horizontalRuler.repaint();
                    RulerScrollPane.this.verticalRuler.setIndicatorValue(((Long)evt.getNewValue()).intValue());
                    RulerScrollPane.this.verticalRuler.repaint();
                }
            }
        });
        view.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                RulerScrollPane.this.horizontalRuler.setIndicatorValue(e.getX());
                RulerScrollPane.this.horizontalRuler.repaint();
                RulerScrollPane.this.verticalRuler.setIndicatorValue(e.getY());
                RulerScrollPane.this.verticalRuler.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                RulerScrollPane.this.horizontalRuler.setIndicatorValue(e.getX());
                RulerScrollPane.this.horizontalRuler.repaint();
                RulerScrollPane.this.verticalRuler.setIndicatorValue(e.getY());
                RulerScrollPane.this.verticalRuler.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RulerScrollPane.this.horizontalRuler.setIndicatorValue(-1);
                RulerScrollPane.this.horizontalRuler.repaint();
                RulerScrollPane.this.verticalRuler.setIndicatorValue(-1);
                RulerScrollPane.this.verticalRuler.repaint();
            }
        });
        this.setHorizontalScrollBarPolicy(32);
        this.getHorizontalScrollBar().setUnitIncrement(50);
        this.setVerticalScrollBarPolicy(22);
        this.getVerticalScrollBar().setUnitIncrement(50);
    }

    public void setRulerVisible(boolean visible) {
        if (visible) {
            this.setColumnHeaderView(this.horizontalRuler);
            this.setRowHeaderView(this.verticalRuler);
            this.setCorner("UPPER_LEFT_CORNER", this.unitButton);
            this.setCorner("UPPER_RIGHT_CORNER", this.topRightCorner);
            this.setCorner("LOWER_LEFT_CORNER", this.bottomLeftCorner);
        } else {
            this.setColumnHeaderView(null);
            this.setRowHeaderView(null);
            this.setCorner("UPPER_LEFT_CORNER", null);
            this.setCorner("UPPER_RIGHT_CORNER", null);
            this.setCorner("LOWER_LEFT_CORNER", null);
        }
    }

    public void setSelectionRectangle(Rectangle2D rect) {
        this.horizontalRuler.setSelectionRect(rect);
        this.verticalRuler.setSelectionRect(rect);
    }

    public void setUseHardwareAcceleration(boolean useHardwareAcceleration) {
        this.horizontalRuler.setUseHardwareAcceleration(useHardwareAcceleration);
        this.verticalRuler.setUseHardwareAcceleration(useHardwareAcceleration);
    }

    public void setZeroLocation(Point2D location) {
        this.horizontalRuler.setZeroLocation(location.getX());
        this.verticalRuler.setZeroLocation(location.getY());
    }

    public boolean addUnitListener(IRulerListener e) {
        return this.listeners.add(e);
    }

    public boolean removeUnitListener(IRulerListener o) {
        return this.listeners.remove(o);
    }

    public void setZoomLevel(double zoomLevel) {
        this.horizontalRuler.setZoomLevel(zoomLevel);
        this.verticalRuler.setZoomLevel(zoomLevel);
    }

    public void setMetric(boolean isMetric) {
        if (isMetric) {
            this.horizontalRuler.setIsMetric(true);
            this.verticalRuler.setIsMetric(true);
            this.unitButton.setText("cm");
        } else {
            this.horizontalRuler.setIsMetric(false);
            this.verticalRuler.setIsMetric(false);
            this.unitButton.setText("in");
        }
        for (IRulerListener listener : this.listeners) {
            listener.unitsChanged(isMetric);
        }
    }

    public boolean isMouseScrollMode() {
        return this.mouseScrollMode;
    }

    protected void updateRulerSize(int width, int height) {
        this.horizontalRuler.setPreferredWidth(width);
        this.horizontalRuler.invalidate();
        this.verticalRuler.setPreferredHeight(height);
        this.verticalRuler.invalidate();
    }

    class Corner
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private final int orientation;

        public Corner(int orientation) {
            this.orientation = orientation;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Ruler.COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            if (this.orientation == 0) {
                g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            } else if (this.orientation == 1) {
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }
}

