/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckBoxList
extends JList {
    private static final long serialVersionUID = 1L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public CheckBoxList(CheckListItem[] items) {
        super(items);
        this.setCellRenderer(new CheckListRenderer());
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CheckListItem item;
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                if (index < 0) {
                    return;
                }
                item.setSelected(!(item = (CheckListItem)list.getModel().getElementAt(index)).isSelected());
                list.repaint(list.getCellBounds(index, index));
            }
        });
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(((CheckListItem)value).isSelected());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setText(value.toString());
            return this;
        }
    }

    public static class CheckListItem {
        private Object value;
        private boolean isSelected = false;

        public CheckListItem(Object label) {
            this.value = label;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public String toString() {
            return this.value.toString();
        }

        public Object getValue() {
            return this.value;
        }
    }
}

