/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.tree;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.diylc.common.ComponentType;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.plugins.canvas.EmptyTransferable;
import org.diylc.swing.plugins.tree.TreePanel;
import org.diylc.swing.plugins.tree.TreeSourceListener;

class TreeGestureListener
implements DragGestureListener {
    private IPlugInPort presenter;

    public TreeGestureListener(IPlugInPort iPlugInPort) {
        this.presenter = iPlugInPort;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        ComponentType componentType = null;
        TreePanel.Payload payload = null;
        if (this.presenter.getNewComponentTypeSlot() == null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            JTree jTree = (JTree)dragGestureEvent.getComponent();
            Point point = dragGestureEvent.getDragOrigin();
            TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
            if (treePath != null && treePath.getLastPathComponent() instanceof DefaultMutableTreeNode && (payload = (TreePanel.Payload)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) != null && (payload.getComponentType() != null || payload.getClickListener() != null)) {
                componentType = payload.getComponentType();
            }
        } else {
            componentType = this.presenter.getNewComponentTypeSlot();
        }
        boolean bl = false;
        if (componentType == null) {
            if (payload != null && payload.getClickListener() != null) {
                payload.getClickListener().mouseClicked(null);
                bl = true;
            }
        } else {
            this.presenter.setNewComponentTypeSlot(componentType, null, true);
            bl = true;
        }
        if (bl) {
            dragGestureEvent.startDrag(this.presenter.getCursorAt(dragGestureEvent.getDragOrigin()), new EmptyTransferable(), new TreeSourceListener(this.presenter));
        }
    }
}

