/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.toolbox;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.common.ComponentType;
import org.diylc.common.IPlugInPort;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Template;
import org.diylc.images.IconLoader;
import org.diylc.swingframework.openide.DropDownButtonFactory;

public class ComponentButtonFactory {
    public static int MARGIN = 3;
    private static final Pattern contributedPattern = Pattern.compile("^(.*)\\[(.*)\\]");

    public static JButton create(final IPlugInPort iPlugInPort, final ComponentType componentType, JPopupMenu jPopupMenu) {
        JButton jButton = DropDownButtonFactory.createDropDownButton((Icon)componentType.getIcon(), (JPopupMenu)jPopupMenu);
        jButton.setBorder(BorderFactory.createEmptyBorder(MARGIN + 1, MARGIN + 1, MARGIN, MARGIN));
        jButton.setToolTipText("<html><b>" + componentType.getName() + "</b><br>" + componentType.getDescription() + "<br>Author: " + componentType.getAuthor() + "<br><br>Right click to select all components of this type" + "</html>");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                iPlugInPort.setNewComponentTypeSlot(componentType, null, false);
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    List list = iPlugInPort.getCurrentProject().getComponents();
                    ArrayList<IDIYComponent> arrayList = new ArrayList<IDIYComponent>();
                    for (IDIYComponent iDIYComponent : list) {
                        if (!componentType.getInstanceClass().equals(iDIYComponent.getClass())) continue;
                        arrayList.add(iDIYComponent);
                    }
                    if (Utils.isMac() ? mouseEvent.isControlDown() : mouseEvent.isMetaDown()) {
                        arrayList.addAll(iPlugInPort.getSelectedComponents());
                    }
                    iPlugInPort.updateSelection(arrayList);
                    iPlugInPort.setNewComponentTypeSlot(null, null, false);
                    iPlugInPort.refresh();
                }
            }
        });
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                iPlugInPort.keyPressed(keyEvent.getKeyCode(), Utils.isMac() ? keyEvent.isControlDown() : keyEvent.isMetaDown(), keyEvent.isShiftDown(), keyEvent.isAltDown());
            }
        });
        return jButton;
    }

    public static JMenuItem createVariantItem(final IPlugInPort iPlugInPort, final Template template, final ComponentType componentType) {
        String string;
        Object object;
        String string2 = template.getName();
        Matcher matcher = contributedPattern.matcher(string2);
        if (matcher.find()) {
            object = matcher.group(1);
            string = matcher.group(2);
            string2 = "<html>" + (String)object + "<font color='gray'>[" + string + "]</font></html>";
        }
        object = new JMenuItem(string2){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(dimension.width + 32, dimension.height);
            }
        };
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                iPlugInPort.setNewComponentTypeSlot(componentType, template, false);
            }
        });
        string = iPlugInPort.getDefaultVariant(componentType);
        JLabel jLabel = new JLabel(template.getName().equals(string) ? IconLoader.PinGreen.getIcon() : IconLoader.PinGrey.getIcon());
        jLabel.setToolTipText(template.getName().equals(string) ? "Remove default variant" : "Set default variant");
        jLabel.addMouseListener(new MouseAdapter((JMenuItem)object, iPlugInPort, componentType, template){
            final /* synthetic */ JMenuItem val$item;
            final /* synthetic */ IPlugInPort val$plugInPort;
            final /* synthetic */ ComponentType val$componentType;
            final /* synthetic */ Template val$variant;
            {
                this.val$item = jMenuItem;
                this.val$plugInPort = iPlugInPort;
                this.val$componentType = componentType;
                this.val$variant = template;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Container container = this.val$item.getParent();
                if (container != null && container instanceof JPopupMenu) {
                    JPopupMenu jPopupMenu = (JPopupMenu)container;
                    jPopupMenu.setVisible(false);
                }
                this.val$plugInPort.setDefaultVariant(this.val$componentType, this.val$variant.getName());
                mouseEvent.consume();
            }
        });
        EmptyBorder emptyBorder = new EmptyBorder(4, 0, 0, 0);
        jLabel.setBorder(emptyBorder);
        ((AbstractButton)object).setLayout(new FlowLayout(2, 0, 0));
        ((Container)object).add(jLabel);
        jLabel = new JLabel(IconLoader.Garbage.getIcon());
        jLabel.setToolTipText("Delete variant");
        jLabel.addMouseListener(new MouseAdapter((JMenuItem)object, template, iPlugInPort, componentType){
            final /* synthetic */ JMenuItem val$item;
            final /* synthetic */ Template val$variant;
            final /* synthetic */ IPlugInPort val$plugInPort;
            final /* synthetic */ ComponentType val$componentType;
            {
                this.val$item = jMenuItem;
                this.val$variant = template;
                this.val$plugInPort = iPlugInPort;
                this.val$componentType = componentType;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                Container container = this.val$item.getParent();
                if (container != null && container instanceof JPopupMenu) {
                    JPopupMenu jPopupMenu = (JPopupMenu)container;
                    jPopupMenu.setVisible(false);
                }
                if ((n = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(this.val$item), "Are you sure you want to delete variant \"" + this.val$variant.getName() + "\"", "Delete", 0, 2)) != 0) {
                    return;
                }
                this.val$plugInPort.deleteVariant(this.val$componentType, this.val$variant.getName());
                mouseEvent.consume();
            }
        });
        emptyBorder = new EmptyBorder(4, 2, 0, 0);
        jLabel.setBorder(emptyBorder);
        ((AbstractButton)object).setLayout(new FlowLayout(2, 0, 0));
        ((Container)object).add(jLabel);
        return object;
    }
}

