/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.layers;

import java.awt.event.ActionEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.ISwingUI;

public class LayersMenuPlugin
implements IPlugIn {
    private static final String LOCK_LAYERS_TITLE = "Layers";
    private IPlugInPort plugInPort;
    private Map<Layer, Action> lockActionMap = new HashMap<Layer, Action>();
    private Map<Layer, Action> visibleActionMap = new HashMap<Layer, Action>();
    private Map<Integer, Action> selectAllActionMap = new HashMap<Integer, Action>();

    public LayersMenuPlugin(ISwingUI iSwingUI) {
        for (Layer layer : Layer.values()) {
            final int n = layer.getZOrder();
            AbstractAction abstractAction = new AbstractAction("Lock"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LayersMenuPlugin.this.plugInPort.setLayerLocked(n, ((Boolean)this.getValue("SwingSelectedKey")).booleanValue());
                }
            };
            abstractAction.putValue("org.diylc.checkBoxMenuItem", true);
            this.lockActionMap.put(layer, abstractAction);
            AbstractAction abstractAction2 = new AbstractAction("Visible"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LayersMenuPlugin.this.plugInPort.setLayerVisibility(n, this.getValue("SwingSelectedKey") == null ? true : (Boolean)this.getValue("SwingSelectedKey"));
                }
            };
            abstractAction2.putValue("org.diylc.checkBoxMenuItem", true);
            this.visibleActionMap.put(layer, abstractAction2);
            AbstractAction abstractAction3 = new AbstractAction("Select All"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LayersMenuPlugin.this.plugInPort.selectAll(n);
                }
            };
            this.selectAllActionMap.put(n, abstractAction3);
            iSwingUI.injectSubmenu(layer.title, null, LOCK_LAYERS_TITLE);
            iSwingUI.injectMenuAction(abstractAction2, layer.title);
            iSwingUI.injectMenuAction(abstractAction, layer.title);
            iSwingUI.injectMenuAction(abstractAction3, layer.title);
        }
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.LAYER_STATE_CHANGED, EventType.LAYER_VISIBILITY_CHANGED);
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
        block3: {
            block2: {
                if (eventType != EventType.LAYER_STATE_CHANGED) break block2;
                Set set = (Set)objectArray[0];
                for (Layer layer : Layer.values()) {
                    this.lockActionMap.get((Object)layer).putValue("SwingSelectedKey", set.contains(layer.getZOrder()));
                }
                break block3;
            }
            if (eventType != EventType.LAYER_VISIBILITY_CHANGED) break block3;
            Set set = (Set)objectArray[0];
            for (Layer layer : Layer.values()) {
                this.visibleActionMap.get((Object)layer).putValue("SwingSelectedKey", !set.contains(layer.getZOrder()));
            }
        }
    }

    static enum Layer {
        CHASSIS("Chassis", 1),
        BOARD("Board", 2),
        TRACE("Trace", 3),
        COMPONENT("Component", 4),
        TEXT("Text", 5);

        String title;
        int zOrder;

        private Layer(String string2, int n2) {
            this.title = string2;
            this.zOrder = n2;
        }

        public String getTitle() {
            return this.title;
        }

        public int getZOrder() {
            return this.zOrder;
        }
    }
}

