/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.file;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.EnumSet;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.DrawOption;
import org.diylc.common.IPlugInPort;
import org.diylc.swingframework.IDrawingProvider;

public class ProjectDrawingProvider
implements IDrawingProvider {
    private IPlugInPort plugInPort;
    private boolean useZoom;
    private boolean showGridWhenNeeded;
    private boolean includeExtraSpace;

    public ProjectDrawingProvider(IPlugInPort iPlugInPort, boolean bl, boolean bl2, boolean bl3) {
        this.plugInPort = iPlugInPort;
        this.useZoom = bl;
        this.showGridWhenNeeded = bl2;
        this.includeExtraSpace = bl3;
    }

    public Dimension getSize() {
        return this.plugInPort.getCanvasDimensions(this.useZoom, this.includeExtraSpace);
    }

    public void draw(int n, Graphics graphics, double d) {
        EnumSet<DrawOption> enumSet = EnumSet.of(DrawOption.ANTIALIASING);
        if (this.useZoom) {
            enumSet.add(DrawOption.ZOOM);
        }
        if (this.showGridWhenNeeded && ConfigurationManager.getInstance().readBoolean("exportGrid", false)) {
            enumSet.add(DrawOption.GRID);
        }
        if (ConfigurationManager.getInstance().readBoolean("outline", false)) {
            enumSet.add(DrawOption.OUTLINE_MODE);
        }
        if (this.includeExtraSpace) {
            enumSet.add(DrawOption.EXTRA_SPACE);
        }
        this.plugInPort.draw((Graphics2D)graphics, enumSet, null, Double.valueOf(d));
    }

    public int getPageCount() {
        return 1;
    }
}

