/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultCaret;
import org.apache.log4j.Logger;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.IView;
import org.diylc.images.IconLoader;
import org.diylc.plugins.cloud.model.CommentEntity;
import org.diylc.plugins.cloud.model.ProjectEntity;
import org.diylc.plugins.cloud.presenter.CloudPresenter;
import org.diylc.plugins.cloud.presenter.SearchSession;
import org.diylc.presenter.Presenter;
import org.diylc.swing.ISimpleView;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.gui.DummyView;
import org.diylc.swing.gui.components.HTMLTextArea;
import org.diylc.swing.gui.editor.PropertyEditorDialog;
import org.diylc.swing.plugins.cloud.view.CommentDialog;
import org.diylc.swing.plugins.cloud.view.UploadDialog;
import org.diylc.swing.plugins.file.FileFilterEnum;

public class ResultsScrollPanel
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ResultsScrollPanel.class);
    private JPanel resultsPanel;
    private JLabel loadMoreLabel;
    private JLabel topLabel;
    private ISwingUI mainUI;
    private ISimpleView cloudUI;
    private IPlugInPort plugInPort;
    private int currentLocation;
    private boolean armed;
    private SearchSession searchSession;
    private Icon spinnerIcon = IconLoader.Spinning.getIcon();
    private boolean showEditControls;

    public ResultsScrollPanel(ISwingUI iSwingUI, ISimpleView iSimpleView, IPlugInPort iPlugInPort, SearchSession searchSession, boolean bl) {
        this.mainUI = iSwingUI;
        this.cloudUI = iSimpleView;
        this.plugInPort = iPlugInPort;
        this.searchSession = searchSession;
        this.showEditControls = bl;
        this.getVerticalScrollBar().setUnitIncrement(16);
        this.setBorder(null);
        this.setViewportView(this.getResultsPanel());
    }

    public void clearPrevious() {
        this.currentLocation = 0;
        this.getResultsPanel().removeAll();
        this.armed = false;
    }

    public void startSearch(List<ProjectEntity> list) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10000;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 3;
        this.resultsPanel.add((Component)this.getLoadMoreLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.resultsPanel.add((Component)this.getTopLabel(), gridBagConstraints);
        this.addData(list);
    }

    public void showNoMatches() {
        JLabel jLabel = new JLabel("<html><font size='4' color='#999999'>No projects match the search criteria.</font></html>");
        jLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.147483647E9;
        this.getResultsPanel().add((Component)jLabel, gridBagConstraints);
        this.getLoadMoreLabel().setText("");
        this.getLoadMoreLabel().setIcon(null);
        this.remove(this.getTopLabel());
    }

    public void addData(List<ProjectEntity> list) {
        if (list == null || list.isEmpty() && this.currentLocation == 0) {
            this.showNoMatches();
        } else {
            final Point point = this.getViewport().getViewPosition();
            LOG.info((Object)("Adding " + list.size() + " projects to display."));
            for (ProjectEntity projectEntity : list) {
                this.addProjectToDisplay(projectEntity);
                ++this.currentLocation;
            }
            this.getResultsPanel().invalidate();
            this.getResultsPanel().revalidate();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    point.translate(0, -16);
                    ResultsScrollPanel.this.getViewport().setViewPosition(point);
                    LOG.info((Object)"Paging mechanism is armed");
                    ResultsScrollPanel.this.armed = true;
                }
            });
            if (this.searchSession != null && this.searchSession.hasMoreData()) {
                this.getLoadMoreLabel().setText("Querying the cloud for more results...");
                this.getLoadMoreLabel().setIcon(this.spinnerIcon);
            } else {
                this.getLoadMoreLabel().setText("No more results.");
                this.getLoadMoreLabel().setIcon(null);
            }
        }
    }

    private JComponent addProjectToDisplay(final ProjectEntity projectEntity) {
        final JLabel jLabel = new JLabel(this.loadImage(projectEntity.getThumbnailUrl()));
        final JLabel jLabel2 = new JLabel("<html><b>" + projectEntity.getName() + "</b></html>");
        jLabel2.setFont(jLabel2.getFont().deriveFont(12.0f));
        final HTMLTextArea hTMLTextArea = new HTMLTextArea(projectEntity.getDescription());
        hTMLTextArea.setEditable(false);
        hTMLTextArea.setFont(jLabel.getFont());
        hTMLTextArea.setLineWrap(true);
        hTMLTextArea.setWrapStyleWord(true);
        hTMLTextArea.setFocusable(false);
        hTMLTextArea.setRequestFocusEnabled(false);
        DefaultCaret defaultCaret = (DefaultCaret)hTMLTextArea.getCaret();
        defaultCaret.setUpdatePolicy(1);
        hTMLTextArea.setEnabled(false);
        final JLabel jLabel3 = new JLabel(Integer.toString(projectEntity.getCommentCount()), IconLoader.Messages.getIcon(), 2);
        jLabel3.setToolTipText("Click to see and add public comments");
        jLabel3.setCursor(Cursor.getPredefinedCursor(12));
        jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ResultsScrollPanel.this.cloudUI.executeBackgroundTask(new ITask<List<CommentEntity>>(){

                    public List<CommentEntity> doInBackground() throws Exception {
                        return CloudPresenter.Instance.getComments(projectEntity.getId());
                    }

                    public void failed(Exception exception) {
                        ResultsScrollPanel.this.cloudUI.showMessage("Could not open file. Detailed message is in the logs.", "Cloud Error", 0);
                    }

                    public void complete(List<CommentEntity> list) {
                        CommentDialog commentDialog = new CommentDialog(ResultsScrollPanel.this.cloudUI, projectEntity, list);
                        commentDialog.setVisible(true);
                    }
                });
            }
        });
        final JLabel jLabel4 = new JLabel(Integer.toString(projectEntity.getViewCount()), IconLoader.Eye.getIcon(), 2);
        jLabel4.setToolTipText("View count");
        final JLabel jLabel5 = new JLabel(Integer.toString(projectEntity.getDownloadCount()), IconLoader.Download.getIcon(), 2);
        jLabel5.setToolTipText("Download count");
        final JLabel jLabel6 = new JLabel("<html>Category: <b>" + projectEntity.getCategory() + "</b></html>");
        final JLabel jLabel7 = new JLabel("<html>Author: <b>" + projectEntity.getOwner() + "</b></html>");
        final JLabel jLabel8 = new JLabel("<html>Last updated: <b>" + projectEntity.getUpdated() + "</b></html>");
        JLabel jLabel9 = new JLabel(IconLoader.CloudDownload.getIcon());
        jLabel9.setFocusable(true);
        jLabel9.setCursor(Cursor.getPredefinedCursor(12));
        jLabel9.setToolTipText("Download to local drive");
        jLabel9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                final File file = DialogFactory.getInstance().showSaveDialog((JFrame)((Object)ResultsScrollPanel.this.cloudUI), FileFilterEnum.DIY.getFilter(), new File(projectEntity.getName() + ".diy"), FileFilterEnum.DIY.getExtensions()[0], null);
                if (file != null) {
                    ResultsScrollPanel.this.cloudUI.executeBackgroundTask(new ITask<Void>(){

                        public Void doInBackground() throws Exception {
                            LOG.debug((Object)("Downloading project to " + file.getAbsolutePath()));
                            URL uRL = new URL(projectEntity.getDownloadUrl());
                            ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
                            FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                            fileOutputStream.close();
                            return null;
                        }

                        public void complete(Void void_) {
                            if (ResultsScrollPanel.this.cloudUI.showConfirmDialog("Project downloaded to " + file.getAbsolutePath() + ".\nDo you want to open it?", "Cloud", 0, 1) == 0) {
                                if (!ResultsScrollPanel.this.plugInPort.allowFileAction()) {
                                    return;
                                }
                                ResultsScrollPanel.this.mainUI.executeBackgroundTask(new ITask<Void>(){

                                    public Void doInBackground() throws Exception {
                                        LOG.debug((Object)("Opening from " + file.getAbsolutePath()));
                                        ResultsScrollPanel.this.plugInPort.loadProjectFromFile(file.getAbsolutePath());
                                        return null;
                                    }

                                    public void complete(Void void_) {
                                        ResultsScrollPanel.this.mainUI.bringToFocus();
                                    }

                                    public void failed(Exception exception) {
                                        ResultsScrollPanel.this.mainUI.showMessage("Could not open file. Detailed message is in the logs.", "Error", 0);
                                    }
                                }, true);
                            }
                        }

                        public void failed(Exception exception) {
                            ResultsScrollPanel.this.cloudUI.showMessage("Could not save to file. Detailed message is in the logs.", "Error", 0);
                        }
                    });
                }
            }
        });
        final JLabel jLabel10 = new JLabel();
        final JSeparator jSeparator = new JSeparator();
        final JPanel jPanel = new JPanel(new FlowLayout());
        JLabel jLabel11 = new JLabel(IconLoader.CloudEdit.getIcon());
        jLabel11.setFocusable(true);
        jLabel11.setCursor(Cursor.getPredefinedCursor(12));
        jLabel11.setToolTipText("Edit details without changing the project file");
        jLabel11.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                List list = CloudPresenter.Instance.getProjectProperties(projectEntity);
                PropertyEditorDialog propertyEditorDialog = DialogFactory.getInstance().createPropertyEditorDialog(ResultsScrollPanel.this.cloudUI.getOwnerFrame(), list, "Edit Published Project", true);
                propertyEditorDialog.setVisible(true);
                if ("OK".equals(propertyEditorDialog.getSelectedButtonCaption())) {
                    for (PropertyWrapper propertyWrapper : list) {
                        try {
                            propertyWrapper.writeTo((Object)projectEntity);
                        }
                        catch (Exception exception) {
                            LOG.error((Object)"Could not update the project", (Throwable)exception);
                            ResultsScrollPanel.this.cloudUI.showMessage("Could not update the project. Detailed message is in the logs.", "Error", 0);
                            return;
                        }
                    }
                    ResultsScrollPanel.this.cloudUI.executeBackgroundTask(new ITask<ProjectEntity>(){

                        public ProjectEntity doInBackground() throws Exception {
                            CloudPresenter.Instance.updateProjectDetails(projectEntity, ResultsScrollPanel.this.plugInPort.getCurrentVersionNumber().toString());
                            return (ProjectEntity)CloudPresenter.Instance.fetchUserUploads(Integer.valueOf(projectEntity.getId())).get(0);
                        }

                        public void failed(Exception exception) {
                            ResultsScrollPanel.this.cloudUI.showMessage("Could not update the project. Detailed message is in the logs.", "Error", 0);
                        }

                        public void complete(ProjectEntity projectEntity) {
                            jLabel2.setText("<html><b>" + projectEntity.getName() + "</b></html>");
                            hTMLTextArea.setText(projectEntity.getDescription());
                            jLabel6.setText("<html>Category: <b>" + projectEntity.getCategory() + "</b></html>");
                            jLabel8.setText("<html>Last updated: <b>" + projectEntity.getUpdated() + "</b></html>");
                            ResultsScrollPanel.this.cloudUI.showMessage("The project has been updated successfully.", "Upload Success", 1);
                        }
                    });
                }
            }
        });
        JLabel jLabel12 = new JLabel(IconLoader.CloudUpload.getIcon());
        jLabel12.setFocusable(true);
        jLabel12.setCursor(Cursor.getPredefinedCursor(12));
        jLabel12.setToolTipText("Replace project with a new version");
        jLabel12.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ResultsScrollPanel.this.cloudUI.showConfirmDialog("Are you sure you want to replace the project \"" + projectEntity.getName() + "\" with a new file?\nThis opperation is irreversible. Once replaced, the old version of the project cannot be restored.", "Replace Project", 0, 3) == 0) {
                    final Presenter presenter = new Presenter((IView)new DummyView());
                    final File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null, ResultsScrollPanel.this.cloudUI.getOwnerFrame());
                    if (file != null) {
                        LOG.info((Object)("Preparing replacement for project " + projectEntity.getName() + "(" + projectEntity.getId() + ")"));
                        ResultsScrollPanel.this.cloudUI.executeBackgroundTask(new ITask<String[]>(){

                            public String[] doInBackground() throws Exception {
                                LOG.debug((Object)("Uploading from " + file.getAbsolutePath()));
                                presenter.loadProjectFromFile(file.getAbsolutePath());
                                return CloudPresenter.Instance.getCategories();
                            }

                            public void complete(String[] stringArray) {
                                final UploadDialog uploadDialog = DialogFactory.getInstance().createUploadDialog(ResultsScrollPanel.this.cloudUI.getOwnerFrame(), (IPlugInPort)presenter, stringArray, true);
                                uploadDialog.setVisible(true);
                                if ("OK".equals(uploadDialog.getSelectedButtonCaption())) {
                                    try {
                                        final File file2 = File.createTempFile("upload-thumbnail", ".png");
                                        if (ImageIO.write((RenderedImage)uploadDialog.getThumbnail(), "png", file2)) {
                                            ResultsScrollPanel.this.cloudUI.executeBackgroundTask(new ITask<ProjectEntity>(){

                                                public ProjectEntity doInBackground() throws Exception {
                                                    CloudPresenter.Instance.uploadProject(uploadDialog.getName(), uploadDialog.getCategory(), uploadDialog.getDescription(), uploadDialog.getKeywords(), ResultsScrollPanel.this.plugInPort.getCurrentVersionNumber().toString(), file2, file, Integer.valueOf(projectEntity.getId()));
                                                    return (ProjectEntity)CloudPresenter.Instance.fetchUserUploads(Integer.valueOf(projectEntity.getId())).get(0);
                                                }

                                                public void failed(Exception exception) {
                                                    ResultsScrollPanel.this.cloudUI.showMessage(exception.getMessage(), "Upload Error", 0);
                                                }

                                                public void complete(ProjectEntity projectEntity) {
                                                    jLabel2.setText("<html><b>" + projectEntity.getName() + "</b></html>");
                                                    hTMLTextArea.setText(projectEntity.getDescription());
                                                    jLabel6.setText("<html>Category: <b>" + projectEntity.getCategory() + "</b></html>");
                                                    jLabel8.setText("<html>Last updated: <b>" + projectEntity.getUpdated() + "</b></html>");
                                                    jLabel.setIcon(new ImageIcon(uploadDialog.getThumbnail()));
                                                    ResultsScrollPanel.this.cloudUI.showMessage("The project has been replaced successfully.", "Upload Success", 1);
                                                }
                                            });
                                        } else {
                                            ResultsScrollPanel.this.cloudUI.showMessage("Could not prepare temporary files to be uploaded to the cloud.", "Upload Error", 0);
                                        }
                                    }
                                    catch (Exception exception) {
                                        ResultsScrollPanel.this.cloudUI.showMessage(exception.getMessage(), "Upload Error", 0);
                                    }
                                }
                            }

                            public void failed(Exception exception) {
                                ResultsScrollPanel.this.cloudUI.showMessage("Could not open file. " + exception.getMessage(), "Error", 0);
                            }
                        });
                    }
                }
            }
        });
        JLabel jLabel13 = new JLabel(IconLoader.CloudDelete.getIcon());
        jLabel13.setFocusable(true);
        jLabel13.setCursor(Cursor.getPredefinedCursor(12));
        jLabel13.setToolTipText("Delete from the cloud");
        jLabel13.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ResultsScrollPanel.this.cloudUI.showConfirmDialog("Are you sure you want to permanently delete project \"" + projectEntity.getName() + "\" from the cloud?", "Delete Project", 0, 3) == 0) {
                    LOG.info((Object)("Deleting project " + projectEntity.getName() + "(" + projectEntity.getId() + ")"));
                    ResultsScrollPanel.this.cloudUI.executeBackgroundTask(new ITask<Void>(){

                        public Void doInBackground() throws Exception {
                            CloudPresenter.Instance.deleteProject(projectEntity.getId());
                            return null;
                        }

                        public void failed(Exception exception) {
                            ResultsScrollPanel.this.cloudUI.showMessage("Could not delete the project. Detailed message is in the logs.", "Error", 0);
                        }

                        public void complete(Void void_) {
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel2);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel10);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel3);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel4);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel5);
                            ResultsScrollPanel.this.getResultsPanel().remove(hTMLTextArea);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel6);
                            ResultsScrollPanel.this.getResultsPanel().remove(jPanel);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel7);
                            ResultsScrollPanel.this.getResultsPanel().remove(jLabel8);
                            ResultsScrollPanel.this.getResultsPanel().remove(jSeparator);
                        }
                    });
                }
            }
        });
        jPanel.setBackground(Color.white);
        jPanel.add(jLabel9);
        if (this.showEditControls) {
            jPanel.add(jLabel11);
            jPanel.add(jLabel12);
            jPanel.add(jLabel13);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.currentLocation * 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.weightx = 0.0;
        this.getResultsPanel().add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.getResultsPanel().add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.1;
        this.getResultsPanel().add((Component)jLabel10, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this.getResultsPanel().add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.getResultsPanel().add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.getResultsPanel().add((Component)jLabel5, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.getResultsPanel().add((Component)hTMLTextArea, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        this.getResultsPanel().add((Component)jLabel6, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 14;
        this.getResultsPanel().add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        gridBagConstraints.anchor = 18;
        this.getResultsPanel().add((Component)jLabel7, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.getResultsPanel().add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getResultsPanel().add((Component)jSeparator, gridBagConstraints);
        return jLabel2;
    }

    public JLabel getTopLabel() {
        if (this.topLabel == null) {
            this.topLabel = new JLabel("<html><font color='blue'><u>To the top</u></html>");
            this.topLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.topLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ResultsScrollPanel.this.getViewport().setViewPosition(new Point(0, 0));
                }
            });
        }
        return this.topLabel;
    }

    private JLabel getLoadMoreLabel() {
        if (this.loadMoreLabel == null) {
            this.loadMoreLabel = new JLabel("Loading more data..."){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    if (ResultsScrollPanel.this.armed && ResultsScrollPanel.this.searchSession != null && ResultsScrollPanel.this.searchSession.hasMoreData()) {
                        LOG.info((Object)"Paging mechanism is disarmed");
                        ResultsScrollPanel.this.armed = false;
                        SwingWorker<List<ProjectEntity>, Void> swingWorker = new SwingWorker<List<ProjectEntity>, Void>(){

                            @Override
                            protected List<ProjectEntity> doInBackground() throws Exception {
                                return ResultsScrollPanel.this.searchSession.requestMoreData();
                            }

                            @Override
                            protected void done() {
                                try {
                                    List list = (List)this.get();
                                    ResultsScrollPanel.this.addData(list);
                                }
                                catch (Exception exception) {
                                    ResultsScrollPanel.this.cloudUI.showMessage("Search failed! Detailed message is in the logs.", "Search Failed", 0);
                                }
                            }
                        };
                        swingWorker.execute();
                    }
                }
            };
            this.loadMoreLabel.setHorizontalAlignment(0);
            this.loadMoreLabel.setFont(this.loadMoreLabel.getFont().deriveFont(10.0f));
        }
        return this.loadMoreLabel;
    }

    private JPanel getResultsPanel() {
        if (this.resultsPanel == null) {
            this.resultsPanel = new JPanel(new GridBagLayout());
            this.resultsPanel.setBackground(Color.white);
        }
        return this.resultsPanel;
    }

    private Icon loadImage(String string) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            return new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            return IconLoader.MissingImage.getIcon();
        }
    }
}

