/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.images.IconLoader;
import org.diylc.plugins.cloud.model.ProjectEntity;
import org.diylc.plugins.cloud.presenter.CloudPresenter;
import org.diylc.plugins.cloud.presenter.SearchSession;
import org.diylc.swing.ISimpleView;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.cloud.view.browser.ResultsScrollPanel;
import org.diylc.swing.plugins.cloud.view.browser.SearchHeaderPanel;
import org.diylc.swing.plugins.cloud.view.browser.SimpleCloudGlassPane;
import org.diylc.utils.Pair;

public class CloudBrowserFrame
extends JFrame
implements ISimpleView {
    private static final String TITLE = "Search The Cloud";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(CloudBrowserFrame.class);
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private JPanel dashboardPanel;
    private JPanel searchPanel;
    private SearchHeaderPanel searchHeaderPanel;
    private ResultsScrollPanel resultsScrollPane;
    private IPlugInPort plugInPort;
    private SearchSession searchSession;
    private ISwingUI swingUI;

    public CloudBrowserFrame(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
        super(TITLE);
        this.swingUI = iSwingUI;
        this.setIconImage(IconLoader.Cloud.getImage());
        this.setPreferredSize(new Dimension(700, 640));
        this.plugInPort = iPlugInPort;
        this.searchSession = new SearchSession();
        this.setContentPane(this.getSearchPanel());
        this.pack();
        this.setLocationRelativeTo(iSwingUI.getOwnerFrame());
        this.setGlassPane(SimpleCloudGlassPane.GLASS_PANE);
        JRootPane jRootPane = SwingUtilities.getRootPane(this.getSearchHeaderPanel().getGoButton());
        jRootPane.setDefaultButton(this.getSearchHeaderPanel().getGoButton());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && !this.getSearchHeaderPanel().isInitialized()) {
            this.executeBackgroundTask(new ITask<Pair<String[], String[]>>(){

                public Pair<String[], String[]> doInBackground() throws Exception {
                    return new Pair((Object)CloudPresenter.Instance.getCategories(), (Object)CloudPresenter.Instance.getSortings());
                }

                public void failed(Exception exception) {
                    LOG.error((Object)"Could not fetch categories and sortings from the cloud", (Throwable)exception);
                    CloudBrowserFrame.this.showMessage("Could not fetch categories and sortings from the cloud", "Cloud Error", 0);
                }

                public void complete(Pair<String[], String[]> pair) {
                    CloudBrowserFrame.this.getSearchHeaderPanel().initializeLists((String[])pair.getFirst(), (String[])pair.getSecond());
                }
            });
        }
    }

    public JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.mainPanel.add((Component)this.getTabbedPane(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Dashboard", IconLoader.Dashboard.getIcon(), this.getDashboardPanel());
            this.tabbedPane.addTab("Search For Projects", IconLoader.Find.getIcon(), this.getSearchPanel());
            this.tabbedPane.setSelectedIndex(1);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (CloudBrowserFrame.this.getTabbedPane().getSelectedIndex() == 1) {
                        CloudBrowserFrame.this.getSearchHeaderPanel().setFocus();
                    }
                }
            });
        }
        return this.tabbedPane;
    }

    private JPanel getDashboardPanel() {
        if (this.dashboardPanel == null) {
            this.dashboardPanel = new JPanel();
        }
        return this.dashboardPanel;
    }

    private JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.searchPanel.setBackground(Color.white);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.searchPanel.add((Component)this.getSearchHeaderPanel(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.searchPanel.add((Component)this.getResultsScrollPane(), gridBagConstraints);
        }
        return this.searchPanel;
    }

    private SearchHeaderPanel getSearchHeaderPanel() {
        if (this.searchHeaderPanel == null) {
            this.searchHeaderPanel = new SearchHeaderPanel();
            this.searchHeaderPanel.getGoButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CloudBrowserFrame.this.search();
                }
            });
        }
        return this.searchHeaderPanel;
    }

    private ResultsScrollPanel getResultsScrollPane() {
        if (this.resultsScrollPane == null) {
            this.resultsScrollPane = new ResultsScrollPanel(this.swingUI, this, this.plugInPort, this.searchSession, false);
        }
        return this.resultsScrollPane;
    }

    private void search() {
        this.getResultsScrollPane().clearPrevious();
        this.executeBackgroundTask(new ITask<List<ProjectEntity>>(){

            public List<ProjectEntity> doInBackground() throws Exception {
                return CloudBrowserFrame.this.searchSession.startSession(CloudBrowserFrame.this.getSearchHeaderPanel().getSearchText(), CloudBrowserFrame.this.getSearchHeaderPanel().getCategory(), CloudBrowserFrame.this.getSearchHeaderPanel().getSorting());
            }

            public void failed(Exception exception) {
                CloudBrowserFrame.this.showMessage("Search failed! Detailed message is in the logs. Please report to the author.", "Search Failed", 0);
            }

            public void complete(List<ProjectEntity> list) {
                CloudBrowserFrame.this.getResultsScrollPane().startSearch(list);
            }
        });
    }

    @Override
    public <T> void executeBackgroundTask(final ITask<T> iTask) {
        this.getGlassPane().setVisible(true);
        SwingWorker swingWorker = new SwingWorker<T, Void>(){

            @Override
            protected T doInBackground() throws Exception {
                return iTask.doInBackground();
            }

            @Override
            protected void done() {
                CloudBrowserFrame.this.getGlassPane().setVisible(false);
                try {
                    Object t = this.get();
                    iTask.complete(t);
                }
                catch (ExecutionException executionException) {
                    LOG.error((Object)"Background task execution failed", (Throwable)executionException);
                    iTask.failed((Exception)executionException);
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"Background task execution interrupted", (Throwable)interruptedException);
                    iTask.failed((Exception)interruptedException);
                }
            }
        };
        swingWorker.execute();
    }

    @Override
    public void showMessage(String string, String string2, int n) {
        JOptionPane.showMessageDialog(this, string, string2, n);
    }

    @Override
    public int showConfirmDialog(String string, String string2, int n, int n2) {
        return JOptionPane.showConfirmDialog(this, string, string2, n, n2);
    }

    @Override
    public JFrame getOwnerFrame() {
        return this;
    }
}

