/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view.browser;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.VolatileImage;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.diylc.images.IconLoader;

public class AnimatedCloudGlassPane
extends JPanel
implements MouseListener,
KeyListener {
    public static final AnimatedCloudGlassPane GLASS_PANE = new AnimatedCloudGlassPane();
    private static final long serialVersionUID = -5344758920442881290L;
    private long startTime;
    private final int msPerPx = 6;
    private final Color bgColor = new Color(192, 222, 237);
    private Timer animationTimer;
    private VolatileImage volatileImg;

    public AnimatedCloudGlassPane() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setCursor(new Cursor(3));
        this.setOpaque(false);
        this.setBackground(this.bgColor);
        this.setLayout(new GridBagLayout());
        this.animationTimer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimatedCloudGlassPane.this.repaint();
            }
        });
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.startTime = System.currentTimeMillis();
            this.animationTimer.start();
        } else {
            this.animationTimer.stop();
        }
        super.setVisible(bl);
    }

    private void createBackBuffer() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        this.volatileImg = graphicsConfiguration.createCompatibleVolatileImage(this.getWidth(), this.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        this.createBackBuffer();
        do {
            GraphicsConfiguration graphicsConfiguration;
            int n;
            if ((n = this.volatileImg.validate(graphicsConfiguration = this.getGraphicsConfiguration())) == 2) {
                this.createBackBuffer();
            }
            Graphics graphics2 = this.volatileImg.getGraphics();
            Graphics2D graphics2D = (Graphics2D)graphics2;
            Image image = IconLoader.CloudBg.getImage();
            graphics2D.setColor(this.bgColor);
            graphics2D.fillRect(0, image.getHeight(null), this.getWidth(), this.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            long l = System.currentTimeMillis() - this.startTime;
            long l2 = l / 6L % (long)image.getWidth(null);
            graphics2D.drawImage(image, -((int)l2), 0, null);
            if ((long)image.getWidth(null) - l2 < (long)this.getWidth()) {
                graphics2D.drawImage(image, (int)((long)image.getWidth(null) - l2), 0, null);
            }
            graphics2D.setColor(Color.white);
            graphics2D.setFont(graphics2D.getFont().deriveFont(22.0f));
            String string = "Querying the cloud, please hold on...";
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics2D.getFont());
            Rectangle rectangle = new Rectangle(this.getSize());
            int n2 = (rectangle.width - fontMetrics.stringWidth(string)) / 2;
            int n3 = (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics2D.drawString(string, n2, n3);
            graphics.drawImage(this.volatileImg, 0, 0, this);
        } while (this.volatileImg.contentsLost());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

