/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.plugins.cloud.model.UserEntity;
import org.diylc.swing.gui.components.HTMLTextArea;
import org.diylc.swingframework.ButtonDialog;

public class UserEditDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private JTextField userNameField;
    private JPasswordField passwordField;
    private JPasswordField confirmPasswordField;
    private JTextField emailField;
    private JTextField websiteField;
    private JTextArea bioArea;
    private JScrollPane bioPane;
    private String userName;
    private String password;
    private String email;
    private String website;
    private String bio;
    private UserEntity existingEntity;

    public UserEditDialog(JFrame jFrame, UserEntity userEntity) {
        super(jFrame, userEntity == null ? "New Account" : "Manage Account", new String[]{"OK", "Cancel"});
        this.existingEntity = userEntity;
        this.setMinimumSize(new Dimension(240, 32));
        this.layoutGui();
        this.refreshState();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getBio() {
        return this.bio;
    }

    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(4, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.mainPanel.add((Component)new JLabel("User Name:"), gridBagConstraints);
            if (this.existingEntity == null) {
                gridBagConstraints.gridy = 1;
                this.mainPanel.add((Component)new JLabel("Password:"), gridBagConstraints);
                gridBagConstraints.gridy = 2;
                this.mainPanel.add((Component)new JLabel("Confirm Password:"), gridBagConstraints);
            }
            gridBagConstraints.gridy = 3;
            this.mainPanel.add((Component)new JLabel("eMail:"), gridBagConstraints);
            gridBagConstraints.gridy = 4;
            this.mainPanel.add((Component)new JLabel("Website:"), gridBagConstraints);
            gridBagConstraints.gridy = 5;
            this.mainPanel.add((Component)new JLabel("Short Bio:"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            this.mainPanel.add((Component)this.getUserNameField(), gridBagConstraints);
            if (this.existingEntity == null) {
                gridBagConstraints.gridy = 1;
                this.mainPanel.add((Component)this.getPasswordField(), gridBagConstraints);
                gridBagConstraints.gridy = 2;
                this.mainPanel.add((Component)this.getConfirmPasswordField(), gridBagConstraints);
            }
            gridBagConstraints.gridy = 3;
            this.mainPanel.add((Component)this.getEmailField(), gridBagConstraints);
            gridBagConstraints.gridy = 4;
            this.mainPanel.add((Component)this.getWebsiteField(), gridBagConstraints);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 1;
            this.mainPanel.add((Component)this.getBioPane(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    private void refreshState() {
        String string;
        this.userName = this.getUserNameField().getText();
        String string2 = new String(this.getPasswordField().getPassword());
        this.password = string2.equals(string = new String(this.getConfirmPasswordField().getPassword())) ? string2 : null;
        this.email = this.getEmailField().getText();
        this.website = this.getWebsiteField().getText();
        this.bio = this.getBioArea().getText();
        JButton jButton = this.getButton("OK");
        jButton.setEnabled(this.userName.length() > 0 && (this.existingEntity != null || this.password != null && this.password.length() > 0));
    }

    private JTextField getUserNameField() {
        if (this.userNameField == null) {
            this.userNameField = new JTextField();
            if (this.existingEntity != null) {
                this.userNameField.setText(this.existingEntity.getUsername());
                this.userNameField.setEditable(false);
            }
            this.userNameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }
            });
        }
        return this.userNameField;
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }
            });
        }
        return this.passwordField;
    }

    private JPasswordField getConfirmPasswordField() {
        if (this.confirmPasswordField == null) {
            this.confirmPasswordField = new JPasswordField();
            this.confirmPasswordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }
            });
        }
        return this.confirmPasswordField;
    }

    private JTextField getEmailField() {
        if (this.emailField == null) {
            this.emailField = new JTextField();
            if (this.existingEntity != null) {
                this.emailField.setText(this.existingEntity.getEmail());
            }
            this.emailField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }
            });
        }
        return this.emailField;
    }

    private JTextField getWebsiteField() {
        if (this.websiteField == null) {
            this.websiteField = new JTextField();
            if (this.existingEntity != null) {
                this.websiteField.setText(this.existingEntity.getWebsite());
            }
            this.websiteField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }
            });
        }
        return this.websiteField;
    }

    private JScrollPane getBioPane() {
        if (this.bioPane == null) {
            this.bioPane = new JScrollPane(this.getBioArea());
            this.bioPane.setPreferredSize(new Dimension(192, 64));
            this.bioPane.setBorder(this.getBioArea().getBorder());
            this.getBioArea().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return this.bioPane;
    }

    private JTextArea getBioArea() {
        if (this.bioArea == null) {
            this.bioArea = new HTMLTextArea();
            if (this.existingEntity != null) {
                this.bioArea.setText(this.existingEntity.getBio());
            }
            this.bioArea.setFont(this.getUserNameField().getFont());
            this.bioArea.setBorder(this.getUserNameField().getBorder());
            this.bioArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    UserEditDialog.this.refreshState();
                }
            });
        }
        return this.bioArea;
    }
}

