/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.diylc.common.ITask;
import org.diylc.plugins.cloud.model.CommentEntity;
import org.diylc.plugins.cloud.model.ProjectEntity;
import org.diylc.plugins.cloud.presenter.CloudPresenter;
import org.diylc.swing.ISimpleView;
import org.diylc.swing.gui.components.HTMLTextArea;

public class CommentDialog
extends JDialog {
    private static final String JUST_NOW = "just now";
    private static final long serialVersionUID = 1L;
    private ProjectEntity project;
    private List<CommentEntity> comments;
    private JPanel mainPanel;
    private JPanel listPanel;
    private JTextArea replyArea;
    private JButton sendButton;
    private int lastPosition = 0;
    private ISimpleView cloudUI;

    public CommentDialog(ISimpleView iSimpleView, ProjectEntity projectEntity, List<CommentEntity> list) {
        super((Frame)iSimpleView.getOwnerFrame(), "Comments on " + projectEntity.getName());
        this.project = projectEntity;
        this.comments = list;
        this.cloudUI = iSimpleView;
        this.setMinimumSize(new Dimension(400, 600));
        this.setContentPane(this.getMainPanel());
        this.pack();
        this.setLocationRelativeTo(iSimpleView.getOwnerFrame());
        this.setModal(true);
        if (!CloudPresenter.Instance.isLoggedIn()) {
            this.getReplyArea().setEnabled(false);
            this.getReplyArea().setText("Must be logged in to reply.");
            this.getSendButton().setEnabled(false);
        }
    }

    private JPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new JPanel(new GridBagLayout());
            this.listPanel.setBackground(Color.white);
            for (CommentEntity commentEntity : this.comments) {
                this.addComment(commentEntity);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 10000;
                gridBagConstraints.weighty = 1.0;
                this.listPanel.add((Component)new JLabel(), gridBagConstraints);
            }
        }
        return this.listPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBackground(Color.white);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 3.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            JScrollPane jScrollPane = new JScrollPane(this.getListPanel());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
            this.mainPanel.add((Component)jScrollPane, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            this.mainPanel.add((Component)new JLabel("Write a reply:"), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.5;
            this.mainPanel.add((Component)new JScrollPane(this.getReplyArea()), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 22;
            this.mainPanel.add((Component)this.getSendButton(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    private JTextArea getReplyArea() {
        if (this.replyArea == null) {
            this.replyArea = new HTMLTextArea();
            this.replyArea.setFont(this.getSendButton().getFont());
        }
        return this.replyArea;
    }

    private JButton getSendButton() {
        if (this.sendButton == null) {
            this.sendButton = new JButton("Send Reply");
            this.sendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final String string = CommentDialog.this.getReplyArea().getText();
                    if (string.trim().length() == 0) {
                        CommentDialog.this.cloudUI.showMessage("Cannot post an empty comment.", "Cloud Error", 0);
                    }
                    CommentDialog.this.cloudUI.executeBackgroundTask(new ITask<Void>(){

                        public Void doInBackground() throws Exception {
                            CloudPresenter.Instance.postComment(CommentDialog.this.project.getId(), string);
                            return null;
                        }

                        public void failed(Exception exception) {
                            CommentDialog.this.cloudUI.showMessage("Error posting comment.", "Cloud Error", 0);
                        }

                        public void complete(Void void_) {
                            CommentDialog.this.getReplyArea().setText("");
                            CommentEntity commentEntity = new CommentEntity();
                            commentEntity.setPostedAt(CommentDialog.JUST_NOW);
                            commentEntity.setUsername(CloudPresenter.Instance.getCurrentUsername());
                            commentEntity.setComment(string);
                            CommentDialog.this.addComment(commentEntity).requestFocusInWindow();
                            CommentDialog.this.getListPanel().revalidate();
                        }
                    });
                }
            });
        }
        return this.sendButton;
    }

    private JTextArea addComment(CommentEntity commentEntity) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.lastPosition++;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.getListPanel().add((Component)new JLabel("<html><b>" + commentEntity.getUsername() + "</b> wrote " + (commentEntity.getPostedAt().equals(JUST_NOW) ? "" : "on ") + commentEntity.getPostedAt() + " </html>"), gridBagConstraints);
        gridBagConstraints.gridy = this.lastPosition++;
        HTMLTextArea hTMLTextArea = new HTMLTextArea(commentEntity.getComment());
        hTMLTextArea.setEditable(false);
        hTMLTextArea.setFont(this.getSendButton().getFont());
        hTMLTextArea.setLineWrap(true);
        hTMLTextArea.setWrapStyleWord(true);
        hTMLTextArea.setForeground(Color.gray);
        this.getListPanel().add((Component)hTMLTextArea, gridBagConstraints);
        gridBagConstraints.gridy = this.lastPosition++;
        gridBagConstraints.fill = 2;
        this.getListPanel().add((Component)new JSeparator(), gridBagConstraints);
        return hTMLTextArea;
    }
}

