/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.canvas;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.VolatileImage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ComponentType;
import org.diylc.common.DrawOption;
import org.diylc.common.IBlockProcessor;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.plugins.canvas.CanvasGestureListener;
import org.diylc.swing.plugins.canvas.CanvasPlugin;
import org.diylc.swing.plugins.canvas.CanvasTargetListener;

public class CanvasPanel
extends JComponent
implements Autoscroll {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(CanvasPlugin.class);
    public static boolean RENDER_VISIBLE_RECT_ONLY = true;
    private IPlugInPort plugInPort;
    private Image bufferImage;
    private GraphicsConfiguration screenGraphicsConfiguration;
    public boolean useHardwareAcceleration = ConfigurationManager.getInstance().readBoolean("hardwareAcceleration", false);
    private HashMap<String, ComponentType> componentTypeCache;

    public CanvasPanel(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.setFocusable(true);
        this.initializeListeners();
        this.initializeDnD();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        this.screenGraphicsConfiguration = graphicsDeviceArray[0].getDefaultConfiguration();
        this.initializeActions();
    }

    public void invalidateCache() {
        this.bufferImage = null;
    }

    public HashMap<String, ComponentType> getComponentTypeCache() {
        if (this.componentTypeCache == null) {
            this.componentTypeCache = new HashMap();
            for (Map.Entry entry : this.plugInPort.getComponentTypes().entrySet()) {
                for (ComponentType componentType : (List)entry.getValue()) {
                    this.componentTypeCache.put(componentType.getInstanceClass().getCanonicalName(), componentType);
                }
            }
        }
        return this.componentTypeCache;
    }

    private void initializeDnD() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 0x40000003, new CanvasGestureListener(this.plugInPort));
        new DropTarget(this, 3, new CanvasTargetListener(this.plugInPort), true);
    }

    private void initializeActions() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(192, 0), "repeatLast");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "clearSlot");
        for (int i = 1; i <= 12; ++i) {
            final int n = i;
            this.getInputMap(2).put(KeyStroke.getKeyStroke(112 + i - 1, 0), "functionKey" + i);
            this.getActionMap().put("functionKey" + i, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasPanel.this.functionKeyPressed(n);
                }
            });
        }
        this.getActionMap().put("clearSlot", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CanvasPanel.this.plugInPort.setNewComponentTypeSlot(null, null, false);
            }
        });
        this.getActionMap().put("repeatLast", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List list = (List)ConfigurationManager.getInstance().readObject("recentComponents", null);
                if (list != null && !list.isEmpty()) {
                    String string = (String)list.get(0);
                    Map map = CanvasPanel.this.plugInPort.getComponentTypes();
                    for (Map.Entry entry : map.entrySet()) {
                        for (ComponentType componentType : (List)entry.getValue()) {
                            if (!componentType.getInstanceClass().getCanonicalName().equals(string)) continue;
                            CanvasPanel.this.plugInPort.setNewComponentTypeSlot(componentType, null, false);
                            CanvasPanel.this.plugInPort.mouseMoved(CanvasPanel.this.getMousePosition(), false, false, false);
                            return;
                        }
                    }
                }
            }
        });
    }

    protected void functionKeyPressed(int n) {
        HashMap hashMap = (HashMap)ConfigurationManager.getInstance().readObject("componentShortcuts", null);
        if (hashMap == null) {
            return;
        }
        String string = (String)hashMap.get("F" + n);
        if (string == null) {
            return;
        }
        if (string.startsWith("block:")) {
            String string2 = string.substring(6);
            try {
                this.plugInPort.loadBlock(string2);
            }
            catch (IBlockProcessor.InvalidBlockException invalidBlockException) {
                LOG.error((Object)("Could not find block assigned to shortcut: " + string2));
            }
        } else {
            ComponentType componentType = this.getComponentTypeCache().get(string);
            if (componentType == null) {
                LOG.error((Object)("Could not find type: " + string));
                return;
            }
            this.plugInPort.setNewComponentTypeSlot(componentType, null, false);
        }
        this.plugInPort.mouseMoved(this.getMousePosition(), false, false, false);
    }

    protected void createBufferImage() {
        int n;
        int n2;
        if (RENDER_VISIBLE_RECT_ONLY) {
            Rectangle rectangle = this.getVisibleRect();
            n2 = rectangle.width;
            n = rectangle.height;
        } else {
            n2 = this.getWidth();
            n = this.getHeight();
        }
        if (this.useHardwareAcceleration) {
            this.bufferImage = this.screenGraphicsConfiguration.createCompatibleVolatileImage(n2, n);
            ((VolatileImage)this.bufferImage).validate(this.screenGraphicsConfiguration);
        } else {
            this.bufferImage = this.createImage(n2, n);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.plugInPort == null) {
            return;
        }
        if (this.bufferImage == null) {
            this.createBufferImage();
        }
        Graphics2D graphics2D = (Graphics2D)this.bufferImage.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        int n = 0;
        int n2 = 0;
        if (RENDER_VISIBLE_RECT_ONLY) {
            n = rectangle.x;
            n2 = rectangle.y;
            graphics2D.translate(-n, -n2);
        } else {
            graphics2D.setClip(rectangle);
        }
        EnumSet<DrawOption> enumSet = EnumSet.of(DrawOption.SELECTION, DrawOption.ZOOM, DrawOption.CONTROL_POINTS);
        if (ConfigurationManager.getInstance().readBoolean("antiAliasing", true)) {
            enumSet.add(DrawOption.ANTIALIASING);
        }
        if (ConfigurationManager.getInstance().readBoolean("outline", false)) {
            enumSet.add(DrawOption.OUTLINE_MODE);
        }
        if (ConfigurationManager.getInstance().readBoolean("showGrid", true)) {
            enumSet.add(DrawOption.GRID);
        }
        if (ConfigurationManager.getInstance().readBoolean("extraSpace", true)) {
            enumSet.add(DrawOption.EXTRA_SPACE);
        }
        this.plugInPort.draw(graphics2D, enumSet, null, null);
        if (this.useHardwareAcceleration) {
            VolatileImage volatileImage = (VolatileImage)this.bufferImage;
            do {
                try {
                    if (volatileImage.contentsLost()) {
                        this.createBufferImage();
                    }
                    graphics.drawImage(this.bufferImage, n, n2, this);
                }
                catch (NullPointerException nullPointerException) {
                    this.createBufferImage();
                }
            } while (volatileImage == null || volatileImage.contentsLost());
        } else {
            graphics.drawImage(this.bufferImage, n, n2, this);
        }
        graphics2D.dispose();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void initializeListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CanvasPanel.this.invalidateCache();
                CanvasPanel.this.invalidate();
            }
        });
    }

    @Override
    public void autoscroll(Point point) {
        this.scrollRectToVisible(new Rectangle(point.x - 15, point.y - 15, 30, 30));
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getVisibleRect();
        return new Insets(rectangle.y - 15, rectangle.x - 15, rectangle.y + rectangle.height + 15, rectangle.x + rectangle.width + 15);
    }

    public void setUseHardwareAcceleration(boolean bl) {
        this.useHardwareAcceleration = bl;
        this.bufferImage = null;
    }
}

