/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.measures.AbstractMeasure;
import org.diylc.swingframework.DoubleArrayTextField;
import org.diylc.utils.Constants;

public class MeasureArrayEditor
extends Container {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(MeasureArrayEditor.class);
    private Color oldBg;
    private DoubleArrayTextField valueField;
    private JComboBox unitBox;

    public MeasureArrayEditor(final PropertyWrapper propertyWrapper) {
        this.setLayout(new BorderLayout());
        AbstractMeasure[] abstractMeasureArray = (AbstractMeasure[])propertyWrapper.getValue();
        Double[] doubleArray = new Double[abstractMeasureArray.length];
        for (int i = 0; i < abstractMeasureArray.length; ++i) {
            doubleArray[i] = abstractMeasureArray[i] == null ? null : abstractMeasureArray[i].getValue();
        }
        this.valueField = new DoubleArrayTextField(abstractMeasureArray == null ? null : doubleArray);
        this.oldBg = this.valueField.getBackground();
        this.valueField.addPropertyChangeListener("DoubleValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    AbstractMeasure[] abstractMeasureArray;
                    Constructor<?> constructor = propertyWrapper.getType().getComponentType().getConstructors()[0];
                    Double[] doubleArray = (Double[])propertyChangeEvent.getNewValue();
                    if (doubleArray == null) {
                        abstractMeasureArray = null;
                    } else {
                        abstractMeasureArray = (AbstractMeasure[])Array.newInstance(propertyWrapper.getType().getComponentType(), doubleArray.length);
                        for (int i = 0; i < doubleArray.length; ++i) {
                            abstractMeasureArray[i] = (AbstractMeasure)constructor.newInstance(doubleArray[i], MeasureArrayEditor.this.unitBox.getSelectedItem());
                        }
                    }
                    propertyWrapper.setValue(abstractMeasureArray);
                    propertyWrapper.setChanged(true);
                    MeasureArrayEditor.this.valueField.setBackground(MeasureArrayEditor.this.oldBg);
                    MeasureArrayEditor.this.unitBox.setBackground(MeasureArrayEditor.this.oldBg);
                }
                catch (Exception exception) {
                    LOG.error((Object)"Error while updating property value", (Throwable)exception);
                }
            }
        });
        this.add((Component)this.valueField, "Center");
        try {
            Type type = ((ParameterizedType)propertyWrapper.getType().getComponentType().getGenericSuperclass()).getActualTypeArguments()[0];
            Method method = ((Class)type).getMethod("values", new Class[0]);
            this.unitBox = new JComboBox<Object>((Object[])method.invoke(null, new Object[0]));
            this.unitBox.setSelectedItem(abstractMeasureArray == null || abstractMeasureArray.length == 0 || abstractMeasureArray[0] == null ? null : abstractMeasureArray[0].getUnit());
            this.unitBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        AbstractMeasure[] abstractMeasureArray;
                        Constructor<?> constructor = propertyWrapper.getType().getComponentType().getConstructors()[0];
                        Double[] doubleArray = MeasureArrayEditor.this.valueField.getValue();
                        if (doubleArray == null) {
                            abstractMeasureArray = null;
                        } else {
                            abstractMeasureArray = (AbstractMeasure[])Array.newInstance(propertyWrapper.getType().getComponentType(), doubleArray.length);
                            for (int i = 0; i < doubleArray.length; ++i) {
                                abstractMeasureArray[i] = (AbstractMeasure)constructor.newInstance(doubleArray[i], MeasureArrayEditor.this.unitBox.getSelectedItem());
                            }
                        }
                        propertyWrapper.setValue(abstractMeasureArray);
                        propertyWrapper.setChanged(true);
                        MeasureArrayEditor.this.valueField.setBackground(MeasureArrayEditor.this.oldBg);
                        MeasureArrayEditor.this.unitBox.setBackground(MeasureArrayEditor.this.oldBg);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)"Error while updating property units", (Throwable)exception);
                    }
                }
            });
            this.add((Component)this.unitBox, "East");
            if (!propertyWrapper.isUnique()) {
                this.valueField.setBackground(Constants.MULTI_VALUE_COLOR);
                this.unitBox.setBackground(Constants.MULTI_VALUE_COLOR);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Error while creating the editor", (Throwable)exception);
        }
    }

    @Override
    public void requestFocus() {
        this.valueField.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.valueField.requestFocusInWindow();
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.valueField.addKeyListener(keyListener);
        this.unitBox.addKeyListener(keyListener);
    }
}

