/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.common.PropertyWrapper;

public class ColorEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String title = "Click to edit";
    private JLabel colorLabel;
    private JTextField colorField;
    private PropertyWrapper property;

    public ColorEditor(PropertyWrapper propertyWrapper) {
        this.property = propertyWrapper;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getColorLabel(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)new JLabel("#"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getColorField(), gridBagConstraints);
    }

    public JLabel getColorLabel() {
        if (this.colorLabel == null) {
            this.colorLabel = new JLabel(this.property.isUnique() ? title : "(multi value) Click to edit"){
                private static final long serialVersionUID = 1L;

                @Override
                public void setBackground(Color color) {
                    if (color.getRed() < 127 || color.getBlue() < 127 || color.getGreen() < 127) {
                        this.setForeground(Color.white);
                    } else {
                        this.setForeground(Color.black);
                    }
                    super.setBackground(color);
                }
            };
            this.colorLabel.setOpaque(true);
            this.colorLabel.setHorizontalAlignment(0);
            this.colorLabel.setBorder(BorderFactory.createEtchedBorder());
            this.colorLabel.setBackground((Color)this.property.getValue());
            this.colorLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.colorLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Color color = JColorChooser.showDialog(ColorEditor.this, "Choose Color", ColorEditor.this.getBackground());
                    if (color != null) {
                        ColorEditor.this.property.setChanged(true);
                        ColorEditor.this.property.setValue((Object)color);
                        ColorEditor.this.getColorLabel().setBackground(color);
                        ColorEditor.this.getColorField().setText(Integer.toHexString(color.getRGB()).substring(2).toUpperCase());
                    }
                }
            });
        }
        return this.colorLabel;
    }

    public JTextField getColorField() {
        if (this.colorField == null) {
            Color color = (Color)this.property.getValue();
            this.colorField = new JTextField(this.property.isUnique() ? Integer.toHexString(color.getRGB()).substring(2).toUpperCase() : "");
            this.colorField.setColumns(6);
            this.colorField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ColorEditor.this.updateColor();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ColorEditor.this.updateColor();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ColorEditor.this.updateColor();
                }
            });
        }
        return this.colorField;
    }

    private void updateColor() {
        Color color;
        if (this.getColorField().getText().length() == 6 && (color = Color.decode("#" + this.getColorField().getText())) != null && this.getColorLabel().getBackground() != color) {
            this.getColorLabel().setBackground(color);
            this.getColorLabel().setText(title);
            this.property.setChanged(true);
            this.property.setValue((Object)color);
        }
    }
}

