/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.DrawOption;
import org.diylc.common.IPlugInPort;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.IView;
import org.diylc.presenter.Presenter;

public class TemplateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(TemplateDialog.class);
    private static final Dimension panelSize = new Dimension(400, 300);
    public static final String SHOW_TEMPLATES_KEY = "showTemplatesAtStartup";
    private IPlugInPort plugInPort;
    private JList fileList;
    private JPanel canvasPanel;
    private Presenter presenter;
    private List<File> files;
    private JCheckBox showTemplatesBox;
    private JPanel mainPanel;
    private JButton loadButton;
    private JPanel infoPanel;

    public TemplateDialog(JFrame jFrame, IPlugInPort iPlugInPort) {
        super((Frame)jFrame, "Templates");
        this.setModal(true);
        this.setResizable(false);
        this.plugInPort = iPlugInPort;
        this.presenter = new Presenter(new IView(){

            public int showConfirmDialog(String string, String string2, int n, int n2) {
                return JOptionPane.showConfirmDialog(TemplateDialog.this, string, string2, n, n2);
            }

            public void showMessage(String string, String string2, int n) {
                JOptionPane.showMessageDialog(TemplateDialog.this, string, string2, n);
            }

            public File promptFileSave() {
                return null;
            }

            public boolean editProperties(List<PropertyWrapper> list, Set<PropertyWrapper> set) {
                return false;
            }
        });
        this.setContentPane(this.getMainPanel());
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            this.mainPanel.add((Component)this.getInfoPanel(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            JScrollPane jScrollPane = new JScrollPane(this.getFileList());
            this.mainPanel.add((Component)jScrollPane, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(jScrollPane.getBorder());
            jPanel.add((Component)this.getCanvasPanel(), "Center");
            this.mainPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 25;
            gridBagConstraints.fill = 0;
            this.mainPanel.add((Component)this.getShowTemplatesBox(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 26;
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
            this.mainPanel.add((Component)this.getLoadButton(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    public JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton("Load Template");
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TemplateDialog.this.plugInPort.loadProject(TemplateDialog.this.presenter.getCurrentProject(), true, null);
                    TemplateDialog.this.dispose();
                }
            });
        }
        return this.loadButton;
    }

    public JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            this.infoPanel.setBackground(Color.decode("#FFFFCC"));
            this.infoPanel.setBorder(new JTextField().getBorder());
            JLabel jLabel = new JLabel("<html>Templates are semi-product layouts that are used as a starting point for your projects.<br>Pick a templete in the left list and click \"Load Template\" to load it or close this dialog to continue.<br>You can create your own templates by placing a DIY file into <b>diylc/templates</b> directory.</html>");
            jLabel.setOpaque(false);
            this.infoPanel.add(jLabel);
        }
        return this.infoPanel;
    }

    public JList getFileList() {
        if (this.fileList == null) {
            this.fileList = new JList<Object>(this.getFiles().toArray());
            this.fileList.setPreferredSize(new Dimension(128, -1));
            this.fileList.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof File) {
                        jLabel.setText(((File)object).getName());
                    }
                    return jLabel;
                }
            });
            this.fileList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    File file = (File)TemplateDialog.this.fileList.getSelectedValue();
                    if (file != null) {
                        TemplateDialog.this.presenter.loadProjectFromFile(file.getAbsolutePath());
                        Dimension dimension = TemplateDialog.this.presenter.getCanvasDimensions(true, true);
                        double d = panelSize.getWidth() / dimension.getWidth();
                        double d2 = panelSize.getHeight() / dimension.getHeight();
                        TemplateDialog.this.presenter.setZoomLevel(Math.min(d, d2));
                        TemplateDialog.this.getCanvasPanel().repaint();
                    }
                }
            });
            this.fileList.setSelectedIndex(0);
        }
        return this.fileList;
    }

    public JCheckBox getShowTemplatesBox() {
        if (this.showTemplatesBox == null) {
            this.showTemplatesBox = new JCheckBox("Show this dialog at startup");
            this.showTemplatesBox.setSelected(true);
            this.showTemplatesBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigurationManager.getInstance().writeValue(TemplateDialog.SHOW_TEMPLATES_KEY, TemplateDialog.this.showTemplatesBox.isSelected());
                }
            });
        }
        return this.showTemplatesBox;
    }

    public List<File> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<File>();
            File file = new File("templates");
            if (file.exists()) {
                for (File file2 : file.listFiles()) {
                    if (!file2.isFile() || !file2.getName().toLowerCase().endsWith(".diy")) continue;
                    this.files.add(file2);
                }
            }
            LOG.debug((Object)("Found " + this.files.size() + " templates"));
        }
        return this.files;
    }

    public JPanel getCanvasPanel() {
        if (this.canvasPanel == null) {
            this.canvasPanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    TemplateDialog.this.presenter.draw((Graphics2D)graphics, EnumSet.of(DrawOption.ZOOM, DrawOption.ANTIALIASING), null, null);
                }
            };
            this.canvasPanel.setBackground(Color.white);
            this.canvasPanel.setPreferredSize(panelSize);
        }
        return this.canvasPanel;
    }
}

