/*
 * Decompiled with CFR 0.152.
 */
package de.jave.undo;

import de.jave.undo.DefaultUndoState;
import de.jave.undo.LogFile;
import de.jave.undo.UndoItem;
import de.jave.undo.UndoState;

public class UndoManager {
    private UndoItem currentItem;
    private UndoItem firstItem;
    private boolean truncated;
    private int maxSize;
    private LogFile logFile;

    @Deprecated
    public UndoManager(Object initialState) {
        this(new DefaultUndoState(initialState));
    }

    public UndoManager(UndoState initialState) {
        this.firstItem = this.currentItem = new UndoItem(initialState);
        this.truncated = false;
        this.logFile = null;
    }

    public void setLogFile(LogFile logFile) {
        this.logFile = logFile;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public String getLogFileName() {
        if (this.logFile == null) {
            return null;
        }
        return this.logFile.getAbsolutePath();
    }

    public boolean isLogging() {
        return this.logFile != null;
    }

    @Deprecated
    public synchronized void saveCurrentState(Object o) {
        this.saveCurrentState(new DefaultUndoState(o));
    }

    public synchronized void saveCurrentState(UndoState o) {
        UndoItem item;
        this.currentItem.next = item = new UndoItem(o);
        item.prev = this.currentItem;
        this.currentItem = item;
        this.ensureMaxSize();
        if (this.logFile != null) {
            this.logFile.append(o);
        }
    }

    public synchronized boolean canUndo() {
        return this.currentItem.prev != null;
    }

    public synchronized boolean isModified() {
        return this.truncated || this.currentItem.prev == null;
    }

    public synchronized UndoState undo() {
        this.currentItem = this.currentItem.prev;
        UndoState result = this.currentItem.getUndoState();
        return result;
    }

    public synchronized UndoState getNextState() {
        if (this.currentItem.next == null) {
            return null;
        }
        return this.currentItem.next.getUndoState();
    }

    public synchronized boolean canRedo() {
        return this.currentItem.next != null;
    }

    public synchronized UndoState redo() {
        this.currentItem = this.currentItem.next;
        UndoState result = this.currentItem.getUndoState();
        return result;
    }

    public synchronized String getUndoActionName() {
        String an = this.currentItem.getUndoActionName();
        if (an != null) {
            return an;
        }
        return "";
    }

    public synchronized String getRedoActionName() {
        UndoItem nextItem = this.currentItem.next;
        if (nextItem == null) {
            return "";
        }
        String an = nextItem.getUndoActionName();
        if (an != null) {
            return an;
        }
        return "";
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.ensureMaxSize();
    }

    protected synchronized void ensureMaxSize() {
        if (this.maxSize <= 0) {
            return;
        }
        UndoItem item = this.firstItem;
        int size = 0;
        while (item != null) {
            size += item.getEstimatedMemorySize();
            item = item.next;
        }
        if (size <= this.maxSize) {
            return;
        }
        while (size > this.maxSize && this.currentItem != this.firstItem.next) {
            this.truncated = true;
            size -= this.firstItem.getEstimatedMemorySize();
            this.firstItem = this.firstItem.next;
            this.firstItem.prev = null;
        }
    }

    public void print() {
        System.out.println("-------------");
        if (this.currentItem == null) {
            System.out.println("LEER");
            return;
        }
        if (this.truncated) {
            System.out.println("*truncated*");
        }
        UndoItem item = this.firstItem;
        int size = 0;
        while (item != null) {
            if (item == this.currentItem) {
                System.out.print("* ");
            } else {
                System.out.print("  ");
            }
            item.print();
            size += item.getEstimatedMemorySize();
            item = item.next;
        }
        if (size > 0) {
            System.err.println(" => " + size + " Bytes");
        }
    }

    public static void main(String[] args) {
        String s = "";
        UndoManager man = new UndoManager(s);
        man.print();
        s = s + "A";
        man.saveCurrentState(s);
        s = s + "B";
        man.saveCurrentState(s);
        s = s + "C";
        man.saveCurrentState(s);
        s = man.undo().toString();
        s = man.undo().toString();
        s = s + "D";
        man.saveCurrentState(s);
    }
}

