/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.ellipsealgorithmic;

import de.jave.gfx.GfxTools;
import de.jave.jave.EllipseAlgorithm;
import de.jave.jave.JavEApplication;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Tool;
import de.jave.jave.algorithm.freehandalgorithmic.FreehandAlgorithm;
import de.jave.jave.algorithm.freehandalgorithmic.FreehandAlgorithmicMode;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import de.jave.jave.tool.ellipsealgorithmic.AlgorithmicEllipseStyle;
import de.jave.jave.tool.ellipsealgorithmic.EllipseAlgorithmicOptions;
import de.jave.jave.tool.ellipsealgorithmic.EllipseAlgorithmicOptionsPanel;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class EllipseAlgorithmicTool
extends Tool {
    private Point location1;
    private Point location2;
    private final EllipseAlgorithmicOptions options = new EllipseAlgorithmicOptions();

    public EllipseAlgorithmicTool(JaveMainPanel plate, JavEApplication asciiPainter) {
        super(plate, asciiPainter);
    }

    @Override
    public String getName() {
        return "Ellipse Algorithmic";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_ELLISPE_ALGORITHMIC_ICON;
    }

    @Override
    public JComponent createOptionsComponent() {
        return new EllipseAlgorithmicOptionsPanel(this.options, this.getMixCharactersModel(), this.getMouseCharacterModel()).getContent();
    }

    @Override
    public void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    @Override
    public void putAside(boolean nextToolIsSelectionTool) {
    }

    @Override
    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        int radiusY;
        if (this.markPlate == null || this.location1 == null || this.location2 == null) {
            return;
        }
        Point location3 = EllipseAlgorithmicTool.getQuadraticLocation(this.location1, this.location2, shiftDown);
        Rectangle r = EllipseAlgorithmicTool.getRectangleFor(this.location1, location3);
        Point p = this.getScreenPointFor(r.x, r.y);
        int oX = this.location1.x;
        int oY = this.location1.y;
        int radiusX = location3.x - this.location1.x;
        if (radiusX < 0) {
            radiusX = -radiusX;
        }
        if ((radiusY = location3.y - this.location1.y) < 0) {
            radiusY = -radiusY;
        }
        int width = radiusX * 2 + 1;
        int height = radiusY * 2 + 1;
        int w = width * this.getPlate().getCharWidth() + 1;
        int h = height * this.getPlate().getCharHeight() + 1;
        g.setColor(colorScheme.getColorToolHelping());
        Point p1 = this.getScreenPointFor(oX - radiusX, oY - radiusY);
        g.drawOval(p1.x + this.getPlate().getCharWidth() / 2, p1.y + this.getPlate().getCharHeight() / 2, w - this.getPlate().getCharWidth(), h - this.getPlate().getCharHeight());
        Point pO = this.getScreenPointFor(oX, oY);
        g.drawOval(pO.x + this.getPlate().getCharWidth() / 2 - 1, pO.y + this.getPlate().getCharHeight() / 2 - 1, 2, 2);
        this.showStatus("(" + r.x + "," + r.y + ") -> (" + (r.x + r.width - 1) + "," + (r.y + r.height - 1) + ")" + " = (" + width + "," + height + ")");
        this.markPlate.clear();
        AlgorithmicEllipseStyle style = this.options.getStyle();
        if (style == AlgorithmicEllipseStyle.CHARACTERS) {
            EllipseAlgorithm.drawEllipse(this.markPlate, oX, oY, radiusX, radiusY, this.getMouseChar());
            this.markPlate.convert();
        } else {
            EllipseAlgorithm.drawEllipse(this.markPlate, oX, oY, radiusX, radiusY, '#');
            FreehandAlgorithm.convertMarksToFreehandLine(this.markPlate, FreehandAlgorithmicMode.LINES_ROUNDED);
        }
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
        g.setColor(colorScheme.getColorToolHelping());
        GfxTools.drawBrokenRectangle(g, p1.x, p1.y, w, h);
        g.setFont(JaveGlobalRessources.FONT_SMALL);
        g.drawString(width + "x" + height, p1.x + 2, p1.y + 10);
    }

    @Override
    public void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.location1 = location;
        this.location2 = location;
        this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
        this.markPlate.setMode(PixelPlateMode.CHAR);
        this.repaintCursor();
    }

    @Override
    public void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.isMix());
        this.markPlate.pasteResultInto(this.getPlate().getContent());
        this.markPlate = null;
        this.saveCurrentState("draw ellipse");
        this.repaintAll();
    }

    @Override
    public void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintCursor();
            }
            return;
        }
        if (location.equals(this.location2)) {
            return;
        }
        this.location2 = location;
        this.repaintCursor();
    }

    @Override
    public void keyPressed(int code, KeyEvent evt) {
        if (code == 27) {
            this.location1 = null;
            this.location2 = null;
            this.repaintCursor();
        }
    }
}

